/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.tools.FileHandler;

public class JPTmpDirectory
extends AbstractJPDirectory {
    public static final String SYSTEM_TMP_DIRECTORY = System.getProperty("java.io.tmpdir", "/tmp");
    public static final String TEST_DIRECTORY = "test";
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--tmp"};
    private static final Object deletionLock = new Object();
    private File tmpDefaultDirectory;

    public JPTmpDirectory() {
        super(COMMAND_IDENTIFIERS, FileHandler.ExistenceHandling.Must, FileHandler.AutoMode.Off);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Object object = deletionLock;
            synchronized (object) {
                try {
                    if (this.getValue() == null) {
                        return;
                    }
                    if (((File)this.getValue()).exists()) {
                        FileUtils.deleteQuietly((File)((File)this.getValue()));
                    }
                    if (((File)this.getValue()).getAbsolutePath().equals(this.tmpDefaultDirectory.getAbsolutePath())) {
                        if (JPService.testMode()) {
                            this.deleteDirectoryIfEmpty(new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + TEST_DIRECTORY + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(JPService.getApplicationName())));
                            this.deleteDirectoryIfEmpty(new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + TEST_DIRECTORY));
                        } else {
                            this.deleteDirectoryIfEmpty(new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(JPService.getApplicationName())));
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    JPService.printError("Could not delete tmp directory!", ex);
                }
            }
        }));
    }

    private void deleteDirectoryIfEmpty(File file) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        File[] subfiles = file.listFiles();
        if (subfiles != null && subfiles.length > 0) {
            for (File child : Objects.requireNonNull(subfiles)) {
                this.deleteDirectoryIfEmpty(child);
            }
        }
        try {
            if (FileUtils.isEmptyDirectory((File)file)) {
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected File getPropertyDefaultValue() {
        File tmpFolder = JPService.testMode() ? new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + TEST_DIRECTORY + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(JPService.getApplicationName()) + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(System.getProperty("user.name", "mrpink"))) : new File(SYSTEM_TMP_DIRECTORY + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(JPService.getApplicationName()) + File.separatorChar + JPTmpDirectory.convertIntoValidFileName(System.getProperty("user.name", "mrpink")));
        try {
            FileUtils.forceMkdir((File)tmpFolder);
            this.tmpDefaultDirectory = tmpFolder;
            return tmpFolder;
        }
        catch (IOException ex) {
            JPService.printError("Could not create tmp folder :(", ex);
            this.tmpDefaultDirectory = tmpFolder;
            return new File("/tmp");
        }
    }

    @Override
    public void validate() throws JPValidationException {
        if (JPService.testMode()) {
            this.setAutoCreateMode(FileHandler.AutoMode.On);
            this.setExistenceHandling(FileHandler.ExistenceHandling.Must);
        }
        super.validate();
    }

    @Override
    public String getDescription() {
        return "Specifies the application temporary directory which is used for lockfiles and application caches.";
    }
}

