/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.tools;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHandler.class);
    public static final FileCreator DEFAULT_FILE_CREATOR = new FileCreator(){

        @Override
        public boolean create(File file) throws IOException {
            return file.createNewFile();
        }
    };

    public static File handle(String uri, FileType type, ExistenceHandling existenceHandling, AutoMode autoMode) throws Exception {
        return FileHandler.handle(uri, type, existenceHandling, autoMode, DEFAULT_FILE_CREATOR);
    }

    public static File handle(String uri, FileType type, ExistenceHandling existenceHandling, AutoMode autoMode, FileCreator creator) throws Exception {
        return FileHandler.handle(new File(uri), type, existenceHandling, autoMode, creator);
    }

    public static File handle(File file, FileType type, ExistenceHandling existenceHandling, AutoMode autoMode) throws Exception {
        return FileHandler.handle(file, type, existenceHandling, autoMode, DEFAULT_FILE_CREATOR);
    }

    public static File handle(File file, FileType type, ExistenceHandling existenceHandling, AutoMode autoMode, FileCreator creator) throws Exception {
        if (file.exists()) {
            switch (type) {
                case File: {
                    if (file.isFile()) break;
                    throw new IOException("URI[" + file.getAbsolutePath() + "] is not a " + type.name().toLowerCase() + "!");
                }
                case Directory: {
                    if (file.isDirectory()) break;
                    throw new IOException("URI[" + file.getAbsolutePath() + "] is not a " + type.name().toLowerCase() + "!");
                }
                default: {
                    throw new AssertionError((Object)"Unknown type!");
                }
            }
        }
        LOGGER.debug("analyse " + type.name() + "[" + file.getAbsolutePath() + "] exists[" + file.exists() + "] " + (Object)((Object)existenceHandling) + " " + (Object)((Object)autoMode));
        switch (existenceHandling) {
            case Must: {
                if (file.exists()) break;
                if (autoMode == AutoMode.Off) {
                    throw new IOException(type.name() + "[" + file.getAbsolutePath() + "] does not exist!");
                }
                FileHandler.create(file, type, creator);
                break;
            }
            case MustNot: {
                if (!file.exists()) break;
                if (autoMode == AutoMode.Off) {
                    throw new IOException(type.name() + "[" + file.getAbsolutePath() + "] exist already!");
                }
                if (!file.canWrite()) {
                    throw new IOException("Could not get delete permissions for " + file.getAbsolutePath());
                }
                LOGGER.info("Delete existing " + type.name().toLowerCase() + " " + file.getAbsolutePath());
                if (file.delete()) break;
                throw new IOException("Could not delete " + file.getAbsolutePath());
            }
            case CanExist: {
                if (file.exists() || autoMode != AutoMode.On) break;
                FileHandler.create(file, type, creator);
                break;
            }
            case MustBeNew: {
                if (file.exists()) {
                    if (autoMode == AutoMode.Off) {
                        throw new IOException(type.name() + " URI[" + file.getAbsolutePath() + "] exist already!");
                    }
                    if (!file.canWrite()) {
                        throw new IOException("Could not get delete permissions for " + file.getAbsolutePath());
                    }
                    LOGGER.info("Delete existing " + type.name().toLowerCase() + " " + file.getAbsolutePath());
                    if (type == FileType.File) {
                        if (!file.delete()) {
                            throw new IOException("Could not delete " + file.getAbsolutePath());
                        }
                    } else if (type == FileType.Directory) {
                        FileUtils.deleteDirectory((File)file);
                    }
                }
                FileHandler.create(file, type, creator);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown handling case!");
            }
        }
        return file;
    }

    public static void create(File file, FileType type, FileCreator creator) throws Exception {
        switch (type) {
            case Directory: {
                LOGGER.info("Create missing " + type.name().toLowerCase() + " " + file.getAbsolutePath());
                try {
                    FileUtils.forceMkdir((File)file);
                    break;
                }
                catch (Exception ex) {
                    throw new IOException("Could not create " + file.getAbsolutePath(), ex);
                }
            }
            case File: {
                if (!file.getParentFile().exists()) {
                    FileHandler.create(file.getParentFile(), FileType.Directory, null);
                }
                if (creator.create(file)) break;
                throw new IOException("Could not create " + file.getAbsolutePath());
            }
            default: {
                throw new AssertionError((Object)("Handling of " + type.name().toLowerCase() + " not defined!"));
            }
        }
    }

    public static interface FileCreator {
        public boolean create(File var1) throws Exception;
    }

    public static enum FileType {
        Directory,
        File;

    }

    public static enum ExistenceHandling {
        Must,
        CanExist,
        MustNot,
        MustBeNew;

    }

    public static enum AutoMode {
        On,
        Off;

    }
}

