/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac;

import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.client.UserClient;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.auth.PosixPrincipal;
import ca.nrc.cadc.auth.TokenValidator;
import ca.nrc.cadc.cred.client.CredUtil;
import ca.nrc.cadc.profiler.Profiler;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.LocalAuthority;
import java.net.URI;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class ACIdentityManager
implements IdentityManager {
    private static final Logger log = Logger.getLogger(ACIdentityManager.class);
    private static final Set<URI> SEC_METHODS;
    private static final String PP_PROP;
    private final boolean requireCompletePosixPrincipal;

    public ACIdentityManager() {
        String pval = System.getProperty(PP_PROP);
        if (pval != null) {
            pval = pval.trim();
        }
        this.requireCompletePosixPrincipal = "true".equals(pval);
    }

    public Set<URI> getSecurityMethods() {
        return SEC_METHODS;
    }

    public Subject validate(Subject subject) throws NotAuthenticatedException {
        return TokenValidator.validateTokens((Subject)subject);
    }

    public Subject augment(final Subject subject) {
        boolean needAugment;
        log.debug((Object)("augment START: " + subject));
        if (subject == null) {
            log.debug((Object)("augment DONE null: " + subject));
            return subject;
        }
        if (subject.getPrincipals().isEmpty()) {
            log.debug((Object)("augment DONE no principals: " + subject));
            return subject;
        }
        NumericPrincipal np = this.getNumericPrincipal(subject);
        boolean bl = needAugment = np == null || subject.getPrincipals().size() == 1;
        if (this.requireCompletePosixPrincipal) {
            PosixPrincipal pp = this.getPosixPrincipal(subject);
            log.debug((Object)("augment check posix: " + pp));
            needAugment = needAugment || pp == null || pp.defaultGroup == null || pp.username == null;
        } else {
            log.debug((Object)"augment: requireCompletePosixPrincipal=false");
        }
        if (!needAugment) {
            log.debug((Object)("augment DONE needAugment=false: " + subject));
            return subject;
        }
        try {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    LocalAuthority localAuth = new LocalAuthority();
                    URI serviceURI = localAuth.getServiceURI(Standards.UMS_USERS_01.toASCIIString());
                    UserClient userClient = new UserClient(serviceURI);
                    userClient.augmentSubject(subject);
                    return null;
                }
            };
            Subject servopsSubject = CredUtil.createOpsSubject();
            Subject.doAs(servopsSubject, action);
            log.debug((Object)("augment DONE w/ UserClient: " + subject));
            return subject;
        }
        catch (PrivilegedActionException e) {
            String msg = "Error augmenting subject " + subject;
            throw new RuntimeException(msg, e);
        }
    }

    private NumericPrincipal getNumericPrincipal(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<NumericPrincipal> nps = subject.getPrincipals(NumericPrincipal.class);
        if (!nps.isEmpty()) {
            return nps.iterator().next();
        }
        return null;
    }

    private PosixPrincipal getPosixPrincipal(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<PosixPrincipal> nps = subject.getPrincipals(PosixPrincipal.class);
        if (!nps.isEmpty()) {
            return nps.iterator().next();
        }
        return null;
    }

    public Object toOwner(Subject subject) {
        if (subject == null) {
            return null;
        }
        X500Principal x500Principal = null;
        Set<Principal> principals = subject.getPrincipals();
        for (Principal principal : principals) {
            if (principal instanceof NumericPrincipal) {
                NumericPrincipal cp = (NumericPrincipal)principal;
                UUID id = cp.getUUID();
                return id.getLeastSignificantBits();
            }
            if (!(principal instanceof X500Principal)) continue;
            x500Principal = (X500Principal)principal;
        }
        if (x500Principal == null) {
            return null;
        }
        NumericPrincipal numericPrincipal = this.createX500User(x500Principal);
        subject.getPrincipals().add((Principal)numericPrincipal);
        return numericPrincipal.getUUID().getLeastSignificantBits();
    }

    private NumericPrincipal createX500User(final X500Principal x500Principal) {
        PrivilegedExceptionAction<NumericPrincipal> action = new PrivilegedExceptionAction<NumericPrincipal>(){

            @Override
            public NumericPrincipal run() throws Exception {
                LocalAuthority localAuth = new LocalAuthority();
                URI serviceURI = localAuth.getServiceURI(Standards.UMS_USERS_01.toASCIIString());
                UserClient userClient = new UserClient(serviceURI);
                User newUser = userClient.createUser((Principal)x500Principal);
                Set set = newUser.getIdentities(NumericPrincipal.class);
                if (set.isEmpty()) {
                    throw new IllegalStateException("missing internal id");
                }
                return (NumericPrincipal)set.iterator().next();
            }
        };
        Subject servopsSubject = CredUtil.createOpsSubject();
        try {
            return Subject.doAs(servopsSubject, action);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create internal id for user " + x500Principal.getName(), e);
        }
    }

    public String toDisplayString(Subject subject) {
        if (subject != null) {
            Set<HttpPrincipal> up = subject.getPrincipals(HttpPrincipal.class);
            if (!up.isEmpty()) {
                return up.iterator().next().getName();
            }
            Set<Principal> ps2 = subject.getPrincipals();
            if (!ps2.isEmpty()) {
                return ps2.iterator().next().getName();
            }
        }
        return null;
    }

    public Subject toSubject(Object o) {
        if (o == null) {
            return null;
        }
        Subject ret = this.toSubjectImpl(o);
        Profiler prof = new Profiler(ACIdentityManager.class);
        ret = this.augment(ret);
        prof.checkpoint("CadcIdentityManager.augmentSubject");
        return ret;
    }

    Subject toSubjectImpl(Object o) {
        X500Principal p;
        Long n = null;
        X500Principal xdn = null;
        if (o instanceof String) {
            try {
                n = Long.valueOf((String)o);
            }
            catch (NumberFormatException ex) {
                xdn = new X500Principal((String)o);
            }
        } else if (o instanceof Integer) {
            n = ((Integer)o).longValue();
        } else if (o instanceof Long) {
            n = (Long)o;
        } else {
            throw new IllegalStateException("cannot reconstruct Subject from a " + o.getClass().getName());
        }
        if (n != null && n > 0L) {
            UUID uuid = new UUID(0L, n);
            p = new NumericPrincipal(uuid);
        } else {
            p = xdn;
        }
        if (p == null) {
            return null;
        }
        Subject s = AuthenticationUtil.getCurrentSubject();
        if (s != null) {
            for (Principal cp : s.getPrincipals()) {
                if (!AuthenticationUtil.equals((Principal)p, (Principal)cp)) continue;
                log.debug((Object)("[cache hit] caller Subject matches " + p + ": " + s));
                return s;
            }
        }
        HashSet<X500Principal> pset = new HashSet<X500Principal>();
        pset.add(p);
        Subject ret = new Subject(false, pset, new HashSet(), new HashSet());
        return ret;
    }

    static {
        PP_PROP = ACIdentityManager.class.getName() + ".requireCompletePosixPrincipal";
        TreeSet<URI> tmp = new TreeSet<URI>();
        tmp.add(Standards.SECURITY_METHOD_ANON);
        tmp.add(Standards.SECURITY_METHOD_CERT);
        tmp.add(Standards.SECURITY_METHOD_COOKIE);
        tmp.add(Standards.SECURITY_METHOD_TOKEN);
        SEC_METHODS = Collections.unmodifiableSet(tmp);
    }
}

