/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac;

import ca.nrc.cadc.ac.User;

public class UserRequest {
    private User user;
    private char[] password;

    public UserRequest(User user, char[] password) {
        if (user == null) {
            throw new IllegalArgumentException("null user");
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("null or empty password");
        }
        if (user.getIdentities().isEmpty()) {
            throw new IllegalArgumentException("user has no identities");
        }
        this.user = user;
        this.password = password;
    }

    public User getUser() {
        return this.user;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void clear() {
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 48;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserRequest other = (UserRequest)obj;
        return this.user.equals(other.user);
    }

    public int hashCode() {
        return this.user.hashCode();
    }
}

