/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.Role;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GroupMemberships
implements Comparable {
    private static final Logger log = Logger.getLogger(GroupMemberships.class);
    private String serviceURI;
    private Principal userID;
    private Map<Role, List<Group>> memberships = new HashMap<Role, List<Group>>();
    private Map<Role, Boolean> complete = new HashMap<Role, Boolean>();

    public GroupMemberships() {
        this.init();
    }

    public GroupMemberships(String serviceURI, Principal userID) {
        this.serviceURI = serviceURI;
        this.userID = userID;
        this.init();
    }

    public boolean isComplete(Role role) {
        return this.complete.get((Object)role);
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public List<Group> getMemberships(Role role) {
        return this.memberships.get((Object)role);
    }

    private void init() {
        for (Role role : Role.values()) {
            this.complete.put(role, Boolean.FALSE);
            this.memberships.put(role, new ArrayList());
        }
    }

    public Principal getUserID() {
        return this.userID;
    }

    public void add(Group group, Role role) {
        List<Group> groups = this.memberships.get((Object)role);
        if (!groups.contains(group)) {
            groups.add(group);
        }
    }

    public void add(List<Group> groups, Role role) {
        List<Group> cur = this.memberships.get((Object)role);
        for (Group group : groups) {
            if (!cur.contains(group)) {
                cur.add(group);
            }
            this.complete.put(role, Boolean.TRUE);
        }
    }

    public boolean equals(Object rhs) {
        return rhs != null && rhs instanceof GroupMemberships;
    }

    public int compareTo(Object t) {
        if (this.equals(t)) {
            return 0;
        }
        return -1;
    }
}

