/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.client.GMSClient;
import ca.nrc.cadc.auth.CertCmdArgUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.util.ArgumentMap;
import ca.nrc.cadc.util.Log4jInit;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opencadc.gms.GroupURI;

public class Main
implements PrivilegedAction<Object> {
    private static Logger log = Logger.getLogger(Main.class);
    public static final String ARG_ADD_MEMBER = "add-member";
    public static final String ARG_DEL_MEMBER = "remove-member";
    public static final String ARG_ADD_ADMIN = "add-admin";
    public static final String ARG_DEL_ADMIN = "remove-admin";
    public static final String ARG_CREATE_GROUP = "create";
    public static final String ARG_GET_GROUP = "get";
    public static final String ARG_DELETE_GROUP = "delete";
    public static final String ARG_GROUP = "group";
    public static final String ARG_HELP = "help";
    public static final String ARG_VERBOSE = "verbose";
    public static final String ARG_DEBUG = "debug";
    public static final String ARG_H = "h";
    public static final String ARG_V = "v";
    public static final String ARG_D = "d";
    private ArgumentMap argMap;

    private Main(ArgumentMap args) {
        this.argMap = args;
    }

    public static void main(String[] args) {
        ArgumentMap argMap = new ArgumentMap(args);
        if (argMap.isSet(ARG_HELP) || argMap.isSet(ARG_H)) {
            Main.usage();
            System.exit(0);
        }
        if (argMap.isSet(ARG_DEBUG) || argMap.isSet(ARG_D)) {
            Log4jInit.setLevel((String)"ca.nrc.cadc.ac.client", (Level)Level.DEBUG);
            Log4jInit.setLevel((String)"ca.nrc.cadc.net", (Level)Level.DEBUG);
        } else if (argMap.isSet(ARG_VERBOSE) || argMap.isSet(ARG_V)) {
            Log4jInit.setLevel((String)"ca.nrc.cadc.ac.client", (Level)Level.INFO);
        } else {
            Log4jInit.setLevel((String)"ca", (Level)Level.WARN);
        }
        Main main = new Main(argMap);
        Subject subject = CertCmdArgUtil.initSubject((ArgumentMap)argMap, (boolean)true);
        Object response = subject != null ? Subject.doAs(subject, main) : main.run();
        log.debug((Object)("Response: " + response));
    }

    private String getCommand() {
        if (this.argMap.isSet(ARG_ADD_MEMBER)) {
            return ARG_ADD_MEMBER;
        }
        if (this.argMap.isSet(ARG_CREATE_GROUP)) {
            return ARG_CREATE_GROUP;
        }
        if (this.argMap.isSet(ARG_GET_GROUP)) {
            return ARG_GET_GROUP;
        }
        if (this.argMap.isSet(ARG_DELETE_GROUP)) {
            return ARG_DELETE_GROUP;
        }
        if (this.argMap.isSet(ARG_DEL_MEMBER)) {
            return ARG_DEL_MEMBER;
        }
        if (this.argMap.isSet(ARG_ADD_ADMIN)) {
            return ARG_ADD_ADMIN;
        }
        if (this.argMap.isSet(ARG_DEL_ADMIN)) {
            return ARG_DEL_ADMIN;
        }
        return null;
    }

    private static void usage() {
        System.out.println("Usage: Group management command line tool");
        System.out.println();
        System.out.println("  --create --group=<uri>");
        System.out.println("  --get --group=<uri>");
        System.out.println("  --delete --group=<uri>");
        System.out.println();
        System.out.println("  --add-member --group=<uri> [member]...");
        System.out.println("  --remove-member --group=<uri> [member]...");
        System.out.println();
        System.out.println("  --add-admin --group=<uri> [member]...");
        System.out.println("  --remove-admin --group=<uri> [member]...");
        System.out.println();
        System.out.println("      [member] can be a userID (string) or a");
        System.out.println("      group URI in the form:");
        System.out.println("         ivo://<authority>/gms?<group>  eg:");
        System.out.println("         ivo://cadc.nrc.ca/gms?mygroup");
        System.out.println();
    }

    @Override
    public Object run() {
        try {
            String command = this.getCommand();
            if (command == null) {
                System.err.println("No valid commands.");
                System.out.println();
                Main.usage();
                return null;
            }
            String suri = this.argMap.getValue(ARG_GROUP);
            if (suri == null) {
                throw new IllegalArgumentException("No group specified");
            }
            GroupURI guri = new GroupURI(new URI(suri));
            GMSClient client = new GMSClient(guri.getServiceID());
            String group = guri.getName();
            List members = this.argMap.getPositionalArgs();
            if (command.equals(ARG_ADD_MEMBER)) {
                if (members.isEmpty()) {
                    throw new IllegalArgumentException("No members specified");
                }
                for (String member : members) {
                    try {
                        GroupURI memberURI = new GroupURI(new URI(member));
                        client.addGroupMember(group, memberURI.getName());
                    }
                    catch (IllegalArgumentException e) {
                        client.addUserMember(group, (Principal)new HttpPrincipal(member));
                    }
                }
            } else if (command.equals(ARG_DEL_MEMBER)) {
                if (members.isEmpty()) {
                    throw new IllegalArgumentException("No members specified");
                }
                for (String member : members) {
                    try {
                        GroupURI memberURI = new GroupURI(new URI(member));
                        client.removeGroupMember(group, memberURI.getName());
                    }
                    catch (IllegalArgumentException e) {
                        client.removeUserMember(group, (Principal)new HttpPrincipal(member));
                    }
                }
            } else if (command.equals(ARG_ADD_ADMIN)) {
                if (members.isEmpty()) {
                    throw new IllegalArgumentException("No members specified");
                }
                Group cur = client.getGroup(group);
                boolean changes = false;
                for (String member : members) {
                    GroupURI memberURI = null;
                    HttpPrincipal hp = null;
                    try {
                        memberURI = new GroupURI(new URI(member));
                    }
                    catch (IllegalArgumentException e) {
                        hp = new HttpPrincipal(member);
                    }
                    boolean update = true;
                    if (hp == null) continue;
                    if (hp != null) {
                        block13: for (User user : cur.getUserAdmins()) {
                            for (Principal p : user.getIdentities()) {
                                HttpPrincipal ahp;
                                if (!(p instanceof HttpPrincipal) || !hp.equals((Object)(ahp = (HttpPrincipal)p))) continue;
                                update = false;
                                continue block13;
                            }
                        }
                        if (update) {
                            User adminUser = new User();
                            adminUser.getIdentities().add((Principal)hp);
                            cur.getUserAdmins().add(adminUser);
                            log.info((Object)("admin added: " + member));
                            changes = true;
                            continue;
                        }
                        log.info((Object)("admin found: " + member));
                        continue;
                    }
                    for (Group group2 : cur.getGroupAdmins()) {
                        if (!group2.getID().equals((Object)memberURI)) continue;
                        update = false;
                        break;
                    }
                    if (update) {
                        Group adminGroup = new Group(memberURI);
                        cur.getGroupAdmins().add(adminGroup);
                        log.info((Object)("group admin added: " + member));
                        changes = true;
                        continue;
                    }
                    log.info((Object)("group admin found: " + member));
                }
                if (changes) {
                    client.updateGroup(cur);
                    log.info((Object)"Group updated.");
                }
            } else if (command.equals(ARG_DEL_ADMIN)) {
                if (members.isEmpty()) {
                    throw new IllegalArgumentException("No members specified");
                }
                Group cur = client.getGroup(group);
                boolean changes = false;
                for (String member : members) {
                    Iterator<Object> iter;
                    GroupURI memberURI = null;
                    HttpPrincipal hp = null;
                    try {
                        memberURI = new GroupURI(new URI(member));
                    }
                    catch (IllegalArgumentException e) {
                        hp = new HttpPrincipal(member);
                    }
                    boolean update = false;
                    if (hp != null) {
                        iter = cur.getUserAdmins().iterator();
                        block17: while (iter.hasNext()) {
                            User user = (User)iter.next();
                            for (Principal p : user.getIdentities()) {
                                HttpPrincipal ahp;
                                if (!(p instanceof HttpPrincipal) || !hp.equals((Object)(ahp = (HttpPrincipal)p))) continue;
                                iter.remove();
                                update = true;
                                continue block17;
                            }
                        }
                        if (update) {
                            log.info((Object)("admin removed: " + member));
                            changes = true;
                            continue;
                        }
                        log.info((Object)("admin not found: " + member));
                        continue;
                    }
                    iter = cur.getGroupAdmins().iterator();
                    while (iter.hasNext()) {
                        Group group3 = (Group)iter.next();
                        if (!group3.getID().equals((Object)memberURI)) continue;
                        iter.remove();
                        update = true;
                        break;
                    }
                    if (update) {
                        log.info((Object)("group admin removed: " + member));
                        changes = true;
                        continue;
                    }
                    log.info((Object)("group admin not found: " + member));
                }
                if (changes) {
                    client.updateGroup(cur);
                    log.info((Object)"Group updated.");
                }
            } else if (command.equals(ARG_CREATE_GROUP)) {
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                AccessControlContext accessControlContext = AccessController.getContext();
                Subject subject = Subject.getSubject(accessControlContext);
                Set<X500Principal> principals = subject.getPrincipals(X500Principal.class);
                X500Principal p = principals.iterator().next();
                Group g = new Group(guri);
                User member = new User();
                member.getIdentities().add(p);
                g.getUserMembers().add(member);
                client.createGroup(g);
            } else if (command.equals(ARG_GET_GROUP)) {
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                Group g = client.getGroup(group);
                System.out.println("found: " + g.getID());
                if (g.description != null) {
                    System.out.println("\t" + g.description);
                }
                System.out.println("owner: " + g.getOwner());
                for (User u : g.getUserAdmins()) {
                    System.out.println("admin: " + u.toPrettyString());
                }
                for (Group ga : g.getGroupAdmins()) {
                    System.out.println("admin: " + ga);
                }
                for (User u : g.getUserMembers()) {
                    System.out.println("member: " + u.toPrettyString());
                }
                for (Group gm : g.getGroupMembers()) {
                    System.out.println("member: " + gm);
                }
            } else if (command.equals(ARG_DELETE_GROUP)) {
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                client.deleteGroup(group);
            }
            return null;
        }
        catch (Throwable t) {
            log.error((Object)"ERROR", t);
            return t;
        }
    }
}

