/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.ReaderException;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.UserAlreadyExistsException;
import ca.nrc.cadc.ac.UserNotFoundException;
import ca.nrc.cadc.ac.WriterException;
import ca.nrc.cadc.ac.client.JsonUserListInputStreamWrapper;
import ca.nrc.cadc.ac.xml.UserReader;
import ca.nrc.cadc.ac.xml.UserWriter;
import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.auth.PosixPrincipal;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.RegistryClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class UserClient {
    private static final Logger log = Logger.getLogger(UserClient.class);
    private URI serviceID;

    public UserClient(URI serviceID) throws IllegalArgumentException {
        if (serviceID == null) {
            throw new IllegalArgumentException("Service URI cannot be null.");
        }
        if (serviceID.getFragment() != null) {
            throw new IllegalArgumentException("invalid serviceURI (fragment not allowed): " + serviceID);
        }
        this.serviceID = serviceID;
    }

    public void augmentSubject(Subject subject) throws MalformedURLException {
        Principal principal = this.getPrincipal(subject);
        if (principal != null) {
            String userID = principal.getName();
            String path = "/" + NetUtil.encode((String)userID) + "?idType=" + this.getIdType(principal);
            URL usersURL = this.getRegistryClient().getServiceURL(this.serviceID, Standards.UMS_USERS_01, AuthMethod.CERT);
            URL getUserURL = new URL(usersURL.toExternalForm() + path);
            log.debug((Object)("augmentSubject request to " + getUserURL.toString()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpDownload download = new HttpDownload(getUserURL, (OutputStream)out);
            download.run();
            int responseCode = download.getResponseCode();
            if (responseCode == 404) {
                return;
            }
            if (responseCode != 200) {
                String message = "Error calling /ac to augment subject";
                if (download.getThrowable() != null) {
                    throw new IllegalStateException(message, download.getThrowable());
                }
                throw new IllegalStateException(message);
            }
            subject.getPrincipals().clear();
            subject.getPrincipals().addAll(this.getPrincipals(out));
        }
    }

    public List<User> getDisplayUsers() throws IOException {
        AuthMethod am = this.getAuthMethod();
        URL usersURL = this.getRegistryClient().getServiceURL(this.serviceID, Standards.UMS_USERS_01, am);
        ArrayList<User> webUsers = new ArrayList<User>();
        HttpDownload httpDownload = new HttpDownload(usersURL, (InputStreamWrapper)new JsonUserListInputStreamWrapper(webUsers));
        httpDownload.setRequestProperty("Accept", "application/json");
        httpDownload.run();
        Throwable error = httpDownload.getThrowable();
        if (error != null) {
            String errMessage = error.getMessage();
            int responseCode = httpDownload.getResponseCode();
            log.debug((Object)("getDisplayUsers response " + responseCode + ": " + errMessage));
            if (responseCode == 401 || responseCode == 403 || responseCode == -1) {
                throw new AccessControlException(errMessage);
            }
            if (responseCode == 400) {
                throw new IllegalArgumentException(errMessage);
            }
            throw new IOException("HttpResponse (" + responseCode + ") - " + errMessage);
        }
        log.debug((Object)("Content-Length: " + httpDownload.getContentLength()));
        log.debug((Object)("Content-Type: " + httpDownload.getContentType()));
        return webUsers;
    }

    public User createUser(Principal principal) throws UserAlreadyExistsException, IOException, WriterException, ReaderException, URISyntaxException {
        if (principal == null) {
            throw new IllegalArgumentException("principal required");
        }
        User user = new User();
        user.getIdentities().add(principal);
        UserWriter userWriter = new UserWriter();
        StringBuilder userXML = new StringBuilder();
        userWriter.write(user, userXML);
        AuthMethod am = this.getAuthMethod();
        URL createUserURL = this.getRegistryClient().getServiceURL(this.serviceID, Standards.UMS_USERS_01, am);
        if (createUserURL == null) {
            throw new IllegalArgumentException("No service endpoint for uri " + Standards.UMS_REQS_01);
        }
        log.debug((Object)("createUser request to " + createUserURL.toString()));
        ByteArrayInputStream in = new ByteArrayInputStream(userXML.toString().getBytes());
        HttpUpload put = new HttpUpload((InputStream)in, createUserURL);
        put.run();
        int responseCode = put.getResponseCode();
        if (responseCode == 200 || responseCode == 201) {
            UserReader userReader = new UserReader();
            return userReader.read(put.getResponseBody());
        }
        String message = "";
        if (put.getThrowable() != null) {
            log.debug((Object)"error calling createX509User", put.getThrowable());
            message = put.getThrowable().getMessage();
        }
        if (responseCode == 400) {
            throw new IllegalArgumentException(message);
        }
        if (responseCode == 409) {
            throw new UserAlreadyExistsException(message);
        }
        if (responseCode == 403) {
            throw new AccessControlException(message);
        }
        throw new IllegalStateException(message);
    }

    public User getUser(Principal principal) throws ReaderException, IOException, URISyntaxException, UserNotFoundException {
        String id = NetUtil.encode((String)principal.getName());
        String path = "/" + id + "?idType=" + AuthenticationUtil.getPrincipalType((Principal)principal);
        AuthMethod am = this.getAuthMethod();
        URL usersURL = this.getRegistryClient().getServiceURL(this.serviceID, Standards.UMS_USERS_01, am);
        URL getUserURL = new URL(usersURL.toExternalForm() + path);
        log.debug((Object)("getUser request to " + getUserURL.toString()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpDownload get = new HttpDownload(getUserURL, (OutputStream)out);
        get.run();
        int responseCode = get.getResponseCode();
        if (responseCode == 200) {
            UserReader userReader = new UserReader();
            return userReader.read(out.toString());
        }
        String message = "";
        if (get.getThrowable() != null) {
            log.debug((Object)"error calling get user", get.getThrowable());
            message = get.getThrowable().getMessage();
        }
        if (responseCode == 400) {
            throw new IllegalArgumentException(message);
        }
        if (responseCode == 404) {
            throw new UserNotFoundException(message);
        }
        if (responseCode == 403) {
            throw new AccessControlException(message);
        }
        throw new IllegalStateException(message);
    }

    protected Principal getPrincipal(Subject subject) {
        if (subject == null || subject.getPrincipals() == null || subject.getPrincipals().isEmpty()) {
            return null;
        }
        if (subject.getPrincipals().size() == 1) {
            return subject.getPrincipals().iterator().next();
        }
        Set<X500Principal> x500Principals = subject.getPrincipals(X500Principal.class);
        if (x500Principals.size() > 0) {
            return x500Principals.iterator().next();
        }
        Set<NumericPrincipal> numericPrincipals = subject.getPrincipals(NumericPrincipal.class);
        if (numericPrincipals.size() > 0) {
            return (Principal)numericPrincipals.iterator().next();
        }
        Set<HttpPrincipal> httpPrincipals = subject.getPrincipals(HttpPrincipal.class);
        if (httpPrincipals.size() > 0) {
            return (Principal)httpPrincipals.iterator().next();
        }
        return subject.getPrincipals().iterator().next();
    }

    protected Set<Principal> getPrincipals(ByteArrayOutputStream out) {
        try {
            String userXML = new String(out.toByteArray(), "UTF-8");
            log.debug((Object)("userXML Input to getPrincipals(): " + userXML));
            User user = new UserReader().read(userXML);
            if (user.posixDetails != null) {
                for (PosixPrincipal pp : user.getIdentities(PosixPrincipal.class)) {
                    if (pp.getUidNumber() != user.posixDetails.getUid()) continue;
                    pp.defaultGroup = user.posixDetails.getGid();
                    pp.username = user.posixDetails.getUsername();
                }
            }
            return user.getIdentities();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getIdType(Principal principal) {
        String idTypeStr = AuthenticationUtil.getPrincipalType((Principal)principal);
        if (idTypeStr == null) {
            String msg = "Subject has unsupported principal " + principal.getClass();
            throw new IllegalArgumentException(msg);
        }
        return idTypeStr;
    }

    protected RegistryClient getRegistryClient() {
        return new RegistryClient();
    }

    protected HttpDownload download(URL url, OutputStream outputStream) throws IOException {
        HttpDownload get = new HttpDownload(url, outputStream);
        get.run();
        return get;
    }

    protected OutputStream getOutputStream() {
        return new ByteArrayOutputStream();
    }

    public User whoAmI() throws IOException, UserNotFoundException {
        AuthMethod am = this.getAuthMethod();
        URL whoAmIURL = this.getRegistryClient().getServiceURL(this.serviceID, Standards.UMS_WHOAMI_01, am);
        if (whoAmIURL == null) {
            throw new IllegalArgumentException("No service endpoint for uri " + Standards.UMS_WHOAMI_01);
        }
        log.debug((Object)("getUser request to " + whoAmIURL.toString()));
        OutputStream out = this.getOutputStream();
        HttpDownload get = this.download(whoAmIURL, out);
        int responseCode = get.getResponseCode();
        if (responseCode == 200) {
            UserReader userReader = new UserReader();
            try {
                return userReader.read(out.toString());
            }
            catch (ReaderException | URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        String message = "";
        if (get.getThrowable() != null) {
            log.debug((Object)"error calling get user", get.getThrowable());
            message = get.getThrowable().getMessage();
        }
        if (responseCode == 400) {
            throw new IllegalArgumentException(message);
        }
        if (responseCode == 404) {
            throw new UserNotFoundException(message);
        }
        if (responseCode == 403) {
            throw new AccessControlException(message);
        }
        throw new IllegalStateException(message);
    }

    private AuthMethod getAuthMethod() throws AccessControlException {
        Subject subject = AuthenticationUtil.getCurrentSubject();
        AuthMethod am = AuthenticationUtil.getAuthMethodFromCredentials((Subject)subject);
        if (am == null || am.equals((Object)AuthMethod.ANON)) {
            throw new AccessControlException("Anonymous access not supported.");
        }
        return am;
    }
}

