/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.dali.CartesianTransform;
import ca.nrc.cadc.dali.DaliUtil;
import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.Polygon;
import ca.nrc.cadc.dali.Shape;

public class Circle
implements Shape {
    private Point center;
    private double radius;

    public Circle(Point center, double radius) {
        DaliUtil.assertNotNull("center", center);
        DaliUtil.assertValidRange("radius", radius, 0.0, 360.0);
        this.center = center;
        this.radius = radius;
    }

    public String toString() {
        return "Circle[" + this.center + "," + this.radius + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Circle rhs = (Circle)obj;
        return this.center.equals(rhs.getCenter()) && this.radius == rhs.radius;
    }

    @Override
    public double getArea() {
        return Math.PI * this.radius * this.radius;
    }

    @Override
    public double getSize() {
        return 2.0 * this.radius;
    }

    @Override
    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public double[] toArray() {
        return new double[]{this.center.getLongitude(), this.center.getLatitude(), this.radius};
    }

    public static Polygon generatePolygonApproximation(Circle val, int numVerts) {
        if (numVerts < 4) {
            throw new IllegalArgumentException("number of vertices in approximation too small (min: 4)");
        }
        CartesianTransform trans = CartesianTransform.getTransform(val);
        Point cen = trans.transform(val.getCenter());
        double phi = Math.PI * 2 / (double)numVerts;
        double vdist = val.getRadius() / Math.cos(phi / 2.0);
        CartesianTransform inv = trans.getInverseTransform();
        Polygon ret = new Polygon();
        for (int i = 0; i < numVerts; ++i) {
            double x = cen.getLongitude() + vdist * Math.cos((double)i * phi);
            double y = cen.getLatitude() + vdist * Math.sin((double)i * phi);
            Point p = new Point(x, y);
            p = inv.transform(p);
            ret.getVertices().add(p);
        }
        return ret;
    }
}

