/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.util.ArrayUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class EnergyConverter
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(EnergyConverter.class);
    private static final long serialVersionUID = 201207191700L;
    private static final String[] allUnits;
    private static final String[] freqUnits;
    private static final double[] freqMult;
    private static final String[] enUnits;
    private static final double[] enMult;
    private static final String[] waveUnits;
    private static final double[] waveMult;
    public static final String CORE_SPECSYS = "BARYCENT";
    public static final String CORE_CTYPE = "WAVE";
    public static final String CORE_UNIT = "m";
    public static final String BASE_UNIT_FREQ = "Hz";
    private static final double c = 2.99792458E8;
    private static final double h = 6.62607015E-34;
    private static final double eV = 1.602192E-12;

    public String[] getSupportedUnits() {
        return allUnits;
    }

    public double convert(double value, String ctype, String cunit) {
        return this.toMeters(value, cunit);
    }

    public double convertSpecsys(double value, String specsys) {
        return value;
    }

    public double toMeters(double d, String units) {
        String unit;
        boolean inverseFlag;
        if (units.startsWith("/")) {
            inverseFlag = true;
            unit = units.substring(1);
        } else if (!units.contains(" ") && units.endsWith("-1")) {
            inverseFlag = true;
            unit = units.substring(0, units.indexOf("-1"));
        } else {
            inverseFlag = false;
            unit = units;
        }
        int i = ArrayUtil.matches((String)("^" + unit + "$"), (String[])freqUnits, (boolean)true);
        if (i != -1) {
            return this.freqToMeters(d, i);
        }
        i = ArrayUtil.matches((String)("^" + unit + "$"), (String[])enUnits, (boolean)true);
        if (i != -1) {
            return this.energyToMeters(d, i);
        }
        i = ArrayUtil.matches((String)("^" + unit + "$"), (String[])waveUnits, (boolean)true);
        if (i != -1) {
            return this.wavelengthToMeters(d, i, inverseFlag);
        }
        throw new IllegalArgumentException("Unknown units: " + units);
    }

    public double toHz(double d, String units) {
        int i = ArrayUtil.matches((String)("^" + units + "$"), (String[])freqUnits, (boolean)true);
        if (i != -1) {
            return this.freqToHz(d, i);
        }
        i = ArrayUtil.matches((String)("^" + units + "$"), (String[])enUnits, (boolean)true);
        if (i != -1) {
            return this.energyToHz(d, i);
        }
        i = ArrayUtil.matches((String)("^" + units + "$"), (String[])waveUnits, (boolean)true);
        if (i != -1) {
            return this.wavelengthToHz(d, i);
        }
        throw new IllegalArgumentException("unknown units: " + units);
    }

    public double fromMetres(double metres, String cunit) {
        String unit;
        boolean inverseFlag;
        LOGGER.debug((Object)("Converting from metres (" + metres + ") to " + cunit));
        if (cunit.startsWith("/")) {
            inverseFlag = true;
            unit = cunit.substring(1);
        } else if (!cunit.contains(" ") && cunit.endsWith("-1")) {
            inverseFlag = true;
            unit = cunit.substring(0, cunit.indexOf("-1"));
        } else {
            inverseFlag = false;
            unit = cunit;
        }
        int i = ArrayUtil.matches((String)("^" + unit + "$"), (String[])freqUnits, (boolean)true);
        if (i != -1) {
            return this.metresToFreq(metres, i);
        }
        i = ArrayUtil.matches((String)("^" + unit + "$"), (String[])enUnits, (boolean)true);
        if (i != -1) {
            return this.metresToEnergy(metres, i);
        }
        i = ArrayUtil.matches((String)("^" + unit + "$"), (String[])waveUnits, (boolean)true);
        if (i != -1) {
            return this.metresToWavelength(metres, i, inverseFlag);
        }
        throw new IllegalArgumentException("Unknown units: " + unit);
    }

    private double metresToFreq(double metres, int factorIndex) {
        return 2.99792458E8 / metres / freqMult[factorIndex];
    }

    private double metresToEnergy(double metres, int factorIndex) {
        return 1.9864458571489286E-25 / metres / enMult[factorIndex];
    }

    private double metresToWavelength(double metres, int factorIndex, boolean inverseFlag) {
        double multiplier = waveMult[factorIndex];
        if (inverseFlag) {
            LOGGER.debug((Object)"Inverse units expected.");
            return 1.0 / metres / (1.0 / multiplier);
        }
        return metres / multiplier;
    }

    public double toDeltaMeters(double d1, double d2, String units) {
        double w1 = this.toMeters(d1, units);
        double w2 = this.toMeters(d2, units);
        return Math.abs(w2 - w1);
    }

    public double toDeltaHz(double d1, double d2, String units) {
        double f1 = this.toHz(d1, units);
        double f2 = this.toHz(d2, units);
        return Math.abs(f2 - f1);
    }

    private double freqToMeters(double d, int i) {
        double nu = d * freqMult[i];
        return 2.99792458E8 / nu;
    }

    private double energyToMeters(double d, int i) {
        double e = 1.602192E-12 * d * enMult[i];
        return 1.9864458571489286E-25 / e;
    }

    private double wavelengthToMeters(double d, int i) {
        return this.wavelengthToMeters(d, i, false);
    }

    private double wavelengthToMeters(double d, int i, boolean inverseFlag) {
        double multiplier = waveMult[i];
        if (inverseFlag) {
            return 1.0 / (1.0 / multiplier) / d;
        }
        return d * multiplier;
    }

    private double freqToHz(double d, int i) {
        return d * freqMult[i];
    }

    private double energyToHz(double d, int i) {
        double w = this.energyToMeters(d, i);
        return 2.99792458E8 / w;
    }

    private double wavelengthToHz(double d, int i) {
        double w = this.wavelengthToMeters(d, i);
        return 2.99792458E8 / w;
    }

    static {
        freqUnits = new String[]{BASE_UNIT_FREQ, "kHz", "MHz", "GHz"};
        freqMult = new double[]{1.0, 1000.0, 1000000.0, 1.0E9};
        enUnits = new String[]{"eV", "keV", "MeV", "GeV"};
        enMult = new double[]{1.0, 1000.0, 1000000.0, 1.0E9};
        waveUnits = new String[]{CORE_UNIT, "cm", "mm", "um", "\u00b5m", "nm", "Angstrom", "A"};
        waveMult = new double[]{1.0, 0.01, 0.001, 1.0E-6, 1.0E-6, 1.0E-9, 1.0E-10, 1.0E-10};
        ArrayList<String> allUnitList = new ArrayList<String>(Arrays.asList(freqUnits));
        allUnitList.addAll(Arrays.asList(enUnits));
        allUnitList.addAll(Arrays.asList(waveUnits));
        allUnits = allUnitList.toArray(new String[0]);
    }
}

