/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.dali.DaliUtil;

public class Point {
    private final double cval1;
    private final double cval2;

    public Point(double longitude, double latitude) {
        this.cval1 = longitude;
        this.cval2 = latitude;
    }

    public void validate() {
        DaliUtil.assertValidRange("longitude", this.cval1, 0.0, 360.0);
        DaliUtil.assertValidRange("latitude", this.cval2, -90.0, 90.0);
    }

    public String toString() {
        return "Point[" + this.cval1 + "," + this.cval2 + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Point rhs = (Point)obj;
        return this.cval1 == rhs.cval1 && this.cval2 == rhs.cval2;
    }

    public double getLongitude() {
        return this.cval1;
    }

    public double getLatitude() {
        return this.cval2;
    }

    public double[] toArray() {
        return new double[]{this.cval1, this.cval2};
    }
}

