/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.dali.CartesianTransform;
import ca.nrc.cadc.dali.InvalidPolygonException;
import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class Polygon
implements Shape {
    private static final Logger log = Logger.getLogger(Polygon.class);
    private final List<Point> points = new ArrayList<Point>();
    private transient Point center;
    private transient Double area;
    private transient Double span;
    private transient Boolean ccw;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon[");
        for (Point v : this.points) {
            sb.append(v.getLongitude()).append(" ").append(v.getLatitude()).append(" ");
        }
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    public List<Point> getVertices() {
        return this.points;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Polygon rhs = (Polygon)obj;
        if (this.points.size() != rhs.points.size()) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            Point rp;
            Point tp = this.points.get(i);
            if (tp.equals(rp = rhs.points.get(i))) continue;
            return false;
        }
        return true;
    }

    public double[] toArray() {
        double[] arr = new double[this.points.size() * 2];
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = this.points.get(i);
            arr[i * 2] = p.getLongitude();
            arr[i * 2 + 1] = p.getLatitude();
        }
        return arr;
    }

    public final void validate() throws InvalidPolygonException {
        this.validatePoints();
        this.validateSegments();
        this.initProps();
    }

    public boolean getCounterClockwise() {
        if (this.ccw == null) {
            this.initProps();
        }
        return this.ccw;
    }

    @Override
    public Point getCenter() {
        if (this.center == null) {
            this.initProps();
        }
        return this.center;
    }

    @Override
    public double getArea() {
        if (this.area == null) {
            this.initProps();
        }
        return this.area;
    }

    @Override
    public double getSize() {
        if (this.span == null) {
            this.initProps();
        }
        return this.span;
    }

    public static Polygon flip(Polygon in) {
        Polygon ret = new Polygon();
        for (int i = in.getVertices().size() - 1; i >= 0; --i) {
            Point p = in.getVertices().get(i);
            ret.getVertices().add(p);
        }
        return ret;
    }

    private void initProps() {
        PolygonProperties pp = this.computePolygonProperties();
        if (pp.windCounterClockwise) {
            this.area = pp.area;
            this.center = pp.center;
            this.span = pp.span;
            this.ccw = pp.windCounterClockwise;
        } else {
            double rd = 57.29577951308232;
            double ster = rd * rd;
            this.area = Math.PI * 4 * ster - pp.area;
            double clong = pp.center.getLongitude() + 180.0;
            if (clong < 0.0) {
                clong += 360.0;
            } else if (clong > 360.0) {
                clong -= 360.0;
            }
            double clat = -1.0 * pp.center.getLatitude();
            this.center = new Point(clong, clat);
            this.span = 360.0 - pp.span;
            this.ccw = pp.windCounterClockwise;
        }
    }

    private PolygonProperties computePolygonProperties() {
        Point start;
        CartesianTransform trans = CartesianTransform.getTransform(this);
        Polygon tpoly = trans.transform(this);
        double a = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        Iterator<Point> pi = tpoly.getVertices().iterator();
        Point v1 = start = pi.next();
        while (pi.hasNext()) {
            Point v2 = pi.next();
            double tmp = v1.getLongitude() * v2.getLatitude() - v2.getLongitude() * v1.getLatitude();
            a += tmp;
            cx += (v1.getLongitude() + v2.getLongitude()) * tmp;
            cy += (v1.getLatitude() + v2.getLatitude()) * tmp;
            v1 = v2;
            if (pi.hasNext()) continue;
            v2 = start;
            tmp = v1.getLongitude() * v2.getLatitude() - v2.getLongitude() * v1.getLatitude();
            a += tmp;
            cx += (v1.getLongitude() + v2.getLongitude()) * tmp;
            cy += (v1.getLatitude() + v2.getLatitude()) * tmp;
        }
        cx /= 6.0 * (a *= 0.5);
        cy /= 6.0 * a;
        double d = 0.0;
        for (int i = 0; i < tpoly.getVertices().size(); ++i) {
            Point vi = tpoly.getVertices().get(i);
            for (int j = 0; j < tpoly.getVertices().size(); ++j) {
                Point vj = tpoly.getVertices().get(j);
                double dd = Math.sqrt(Polygon.distanceSquared(v1, vj));
                if (!(dd > d)) continue;
                d = dd;
            }
        }
        PolygonProperties ret = new PolygonProperties();
        boolean bl = ret.windCounterClockwise = a < 0.0;
        if (a < 0.0) {
            a *= -1.0;
        }
        ret.area = a;
        CartesianTransform inv = trans.getInverseTransform();
        ret.center = inv.transform(new Point(cx, cy));
        ret.span = d;
        return ret;
    }

    private void validatePoints() throws InvalidPolygonException {
        if (this.points.size() < 3) {
            throw new InvalidPolygonException("polygon has " + this.points.size() + " points: minimum 3");
        }
        StringBuilder msg = new StringBuilder("invalid Polygon: ");
        for (Point p : this.points) {
            boolean flat;
            boolean flong = p.getLongitude() < 0.0 || p.getLongitude() > 360.0;
            boolean bl = flat = p.getLatitude() < -90.0 || p.getLatitude() > 90.0;
            if (flong && flat) {
                msg.append("longitude,latitude not in [0,360],[-90,90]: ").append(p.getLongitude()).append(",").append(p.getLatitude());
            } else if (flong) {
                msg.append("longitude not in [0,360]: ").append(p.getLongitude());
            } else if (flat) {
                msg.append("latitude not in [-90,90]: ").append(p.getLatitude());
            }
            if (!flong && !flat) continue;
            throw new InvalidPolygonException(msg.toString());
        }
    }

    private void validateSegments() throws InvalidPolygonException {
        Segment s;
        Point v2;
        Point start;
        CartesianTransform trans = CartesianTransform.getTransform(this);
        Polygon tpoly = trans.transform(this);
        Iterator<Point> vi = tpoly.getVertices().iterator();
        ArrayList<Segment> tsegs = new ArrayList<Segment>();
        ArrayList<Segment> psegs = tsegs;
        Point v1 = start = vi.next();
        while (vi.hasNext()) {
            v2 = vi.next();
            s = new Segment(v1, v2);
            tsegs.add(s);
            v1 = v2;
            if (vi.hasNext()) continue;
            v2 = start;
            s = new Segment(v1, v2);
            tsegs.add(s);
        }
        if (this != tpoly) {
            vi = this.getVertices().iterator();
            psegs = new ArrayList();
            v1 = start = vi.next();
            while (vi.hasNext()) {
                v2 = vi.next();
                s = new Segment(v1, v2);
                psegs.add(s);
                v1 = v2;
                if (vi.hasNext()) continue;
                v2 = start;
                s = new Segment(v1, v2);
                psegs.add(s);
            }
        }
        Polygon.intersects(tsegs, psegs);
    }

    private static void intersects(List<Segment> transSegments, List<Segment> origSegments) throws InvalidPolygonException {
        for (int i = 0; i < transSegments.size(); ++i) {
            Segment s1 = transSegments.get(i);
            for (int j = 0; j < transSegments.size(); ++j) {
                Segment s2;
                if (i == j || !Polygon.intersects(s1, s2 = transSegments.get(j))) continue;
                Segment r1 = origSegments.get(i);
                Segment r2 = origSegments.get(j);
                throw new InvalidPolygonException("invalid Polygon: segment intersect " + r1 + " vs " + r2);
            }
        }
    }

    private static boolean intersects(Segment ab, Segment cd) {
        double den = (ab.v2.getLongitude() - ab.v1.getLongitude()) * (cd.v2.getLatitude() - cd.v1.getLatitude()) - (ab.v2.getLatitude() - ab.v1.getLatitude()) * (cd.v2.getLongitude() - cd.v1.getLongitude());
        double rnum = (ab.v1.getLatitude() - cd.v1.getLatitude()) * (cd.v2.getLongitude() - cd.v1.getLongitude()) - (ab.v1.getLongitude() - cd.v1.getLongitude()) * (cd.v2.getLatitude() - cd.v1.getLatitude());
        if (Math.abs(den) < 1.0E-12) {
            if (Math.abs(rnum) < 1.0E-12) {
                double dy;
                double dx;
                if (ab.v2 == cd.v1 || ab.v1 == cd.v2) {
                    return false;
                }
                double len1 = ab.lengthSquared();
                double len2 = cd.lengthSquared();
                Segment s = ab;
                if (len2 > len1) {
                    s = cd;
                }
                if ((dx = Math.abs(s.v1.getLongitude() - s.v2.getLongitude())) > (dy = Math.abs(s.v1.getLatitude() - s.v2.getLatitude()))) {
                    if (ab.v2.getLongitude() < cd.v1.getLongitude()) {
                        return false;
                    }
                    if (ab.v1.getLongitude() > cd.v2.getLongitude()) {
                        return false;
                    }
                } else {
                    if (ab.v2.getLatitude() < cd.v1.getLatitude()) {
                        return false;
                    }
                    if (ab.v1.getLatitude() > cd.v2.getLatitude()) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        double r = rnum / den;
        if (r <= 0.0 || r >= 1.0) {
            return false;
        }
        double snum = (ab.v1.getLatitude() - cd.v1.getLatitude()) * (ab.v2.getLongitude() - ab.v1.getLongitude()) - (ab.v1.getLongitude() - cd.v1.getLongitude()) * (ab.v2.getLatitude() - ab.v1.getLatitude());
        double s = snum / den;
        return !(s <= 0.0) && !(s >= 1.0);
    }

    private static double distanceSquared(Point v1, Point v2) {
        return (v1.getLongitude() - v2.getLongitude()) * (v1.getLongitude() - v2.getLongitude()) + (v1.getLatitude() - v2.getLatitude()) * (v1.getLatitude() - v2.getLatitude());
    }

    private static class Segment {
        Point v1;
        Point v2;

        Segment(Point v1, Point v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        double length() {
            return Math.sqrt(this.lengthSquared());
        }

        double lengthSquared() {
            return Polygon.distanceSquared(this.v1, this.v2);
        }

        public String toString() {
            return "Segment[" + this.v1.getLongitude() + "," + this.v1.getLatitude() + ":" + this.v2.getLongitude() + "," + this.v2.getLatitude() + "]";
        }
    }

    private static class PolygonProperties {
        boolean windCounterClockwise;
        Double area;
        Point center;
        Double span;

        private PolygonProperties() {
        }
    }
}

