/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.ascii;

import ca.nrc.cadc.dali.tables.TableData;
import ca.nrc.cadc.dali.tables.TableWriter;
import ca.nrc.cadc.dali.tables.votable.VOTableDocument;
import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.VOTableResource;
import ca.nrc.cadc.dali.tables.votable.VOTableTable;
import ca.nrc.cadc.dali.util.DefaultFormat;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.FormatFactory;
import ca.nrc.cadc.io.ResourceIterator;
import com.csvreader.CsvWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AsciiTableWriter
implements TableWriter<VOTableDocument> {
    private static final Logger log = Logger.getLogger(AsciiTableWriter.class);
    public static final String CONTENT_TYPE_TSV = "text/tab-separated-values";
    public static final String CONTENT_TYPE_CSV_HDR = "text/csv; header=present";
    public static final String CONTENT_TYPE_CSV = "text/csv";
    public static final String US_ASCII = "US-ASCII";
    public static final char CSV_DELI = ',';
    public static final char TSV_DELI = '\t';
    protected int maxRows;
    private char delimeter;
    private ContentType contentType;
    private FormatFactory formatFactory;

    public AsciiTableWriter(ContentType fmt) {
        this.contentType = fmt;
        this.delimeter = ContentType.CSV.equals((Object)fmt) ? (char)44 : (char)9;
    }

    @Override
    public String getExtension() {
        return this.contentType.getExtension();
    }

    @Override
    public String getContentType() {
        return this.contentType.getValue();
    }

    @Override
    public String getErrorContentType() {
        return "text/plain";
    }

    @Override
    public void setFormatFactory(FormatFactory formatFactory) {
        this.formatFactory = formatFactory;
    }

    @Override
    public void write(Throwable thrown, OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, US_ASCII));
        CsvWriter csv = new CsvWriter((Writer)writer, this.delimeter);
        csv.write(thrown.getMessage());
        csv.endRecord();
        csv.flush();
    }

    @Override
    public void write(VOTableDocument vot, OutputStream out) throws IOException {
        this.write(vot, out, (Long)null);
    }

    @Override
    public void write(VOTableDocument vot, OutputStream out, Long maxrec) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, US_ASCII));
        this.write(vot, writer, maxrec);
    }

    public void write(VOTableDocument vot, Writer out) throws IOException {
        this.write(vot, out, null);
    }

    public void write(VOTableDocument votable, Writer writer, Long maxrec) throws IOException {
        if (this.formatFactory == null) {
            this.formatFactory = new FormatFactory();
        }
        this.writeImpl(votable, writer, maxrec);
    }

    protected void writeImpl(VOTableDocument votable, Writer out, Long maxrec) throws IOException {
        VOTableResource vr = votable.getResourceByType("results");
        VOTableTable vt = vr.getTable();
        TableData td = vt.getTableData();
        List<VOTableField> fields = vt.getFields();
        ArrayList<Format> formats = new ArrayList<Format>();
        if (fields != null && !fields.isEmpty()) {
            for (VOTableField vOTableField : fields) {
                Format format = null;
                format = vOTableField.getFormat() == null ? this.formatFactory.getFormat(vOTableField) : vOTableField.getFormat();
                formats.add(format);
            }
        }
        CsvWriter writer = new CsvWriter(out, this.delimeter);
        try {
            for (VOTableField field : fields) {
                writer.write(field.getName());
            }
            writer.endRecord();
            long l = 0L;
            boolean ok = true;
            ResourceIterator<List<Object>> rows = td.iterator();
            while (ok && rows.hasNext()) {
                List row = (List)rows.next();
                if (!fields.isEmpty() && row.size() != fields.size()) {
                    throw new IllegalStateException("cannot write row: " + fields.size() + " metadata fields, " + row.size() + " data columns");
                }
                for (int i = 0; i < row.size(); ++i) {
                    Object o = row.get(i);
                    Format<Object> fmt = new DefaultFormat();
                    if (!fields.isEmpty()) {
                        fmt = (Format)formats.get(i);
                    }
                    writer.write(fmt.format(o));
                }
                writer.endRecord();
                if (maxrec == null || ++l != maxrec) continue;
                ok = false;
            }
        }
        catch (Exception exception) {
            throw new IOException("error while writing", exception);
        }
        finally {
            writer.flush();
        }
    }

    public static enum ContentType {
        CSV("text/csv; header=present", "csv"),
        TSV("text/tab-separated-values", "tsv");

        private String value;
        private String extension;

        private ContentType(String s, String ext) {
            this.value = s;
            this.extension = ext;
        }

        public String getValue() {
            return this.value;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

