/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable;

import ca.nrc.cadc.dali.tables.votable.VOTableUtil;
import ca.nrc.cadc.dali.util.Format;
import java.util.ArrayList;
import java.util.List;

public class VOTableField {
    private String name;
    private String datatype;
    protected String arraysize;
    protected int[] arrayShape;
    protected Format<Object> format;
    public String ucd;
    public String unit;
    public String utype;
    public String xtype;
    public String description;
    public String nullValue;
    public String id;
    public String ref;
    private final List<String> values = new ArrayList<String>();

    protected VOTableField() {
    }

    public VOTableField(String name, String datatype) {
        this(name, datatype, null);
    }

    public VOTableField(String name, String datatype, String arraysize) {
        this(name, datatype, arraysize, null);
    }

    public VOTableField(String name, String datatype, String arraysize, Format<Object> format) {
        this.name = name;
        this.datatype = datatype;
        this.arraysize = arraysize;
        this.format = format;
        this.validateArraysize();
    }

    private void validateArraysize() {
        this.arrayShape = VOTableUtil.getArrayShape(this.arraysize);
    }

    public String getName() {
        return this.name;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getArraysize() {
        return this.arraysize;
    }

    public Format<Object> getFormat() {
        return this.format;
    }

    public int[] getArrayShape() {
        return this.arrayShape;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setFormat(Format<Object> format) {
        this.format = format;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append(this.name).append(",");
        sb.append(this.datatype);
        if (this.arraysize != null) {
            sb.append(",").append(this.arraysize);
        }
        if (this.xtype != null) {
            sb.append(",").append(this.xtype);
        }
        sb.append("]");
        return sb.toString();
    }
}

