/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable;

import org.apache.log4j.Logger;

public abstract class VOTableUtil {
    private static final Logger log = Logger.getLogger(VOTableUtil.class);

    private VOTableUtil() {
    }

    public static int[] getArrayShape(String arraysize) {
        if (arraysize == null) {
            return null;
        }
        String[] sa = arraysize.split("x");
        int[] arrayShape = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            boolean variableSize;
            String s = sa[i];
            int starIndex = s.indexOf(42);
            boolean bl = variableSize = starIndex >= 0;
            if (variableSize && i != sa.length - 1) {
                throw new IllegalArgumentException("invalid arraysize: " + arraysize + " found * in position " + i);
            }
            String dim = s;
            if (starIndex == 0) {
                dim = "";
            } else if (variableSize) {
                dim = s.substring(0, starIndex);
            }
            try {
                if (dim.length() > 0) {
                    arrayShape[i] = Integer.parseInt(dim);
                    continue;
                }
                arrayShape[i] = -1;
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("invalid arraysize: " + arraysize + " found: " + dim + " expected: integer");
            }
        }
        return arrayShape;
    }

    public static int[] parseArraySize(String arraysize) {
        if (arraysize == null) {
            return null;
        }
        String[] parts = arraysize.split("x");
        int[] arrayShape = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            if (part.endsWith("*")) {
                if (i != parts.length - 1) {
                    throw new IllegalArgumentException("invalid arraysize: " + arraysize + " . expected * only in last dimension");
                }
                arrayShape[i] = -1;
                continue;
            }
            try {
                arrayShape[i] = Integer.parseInt(part);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid arraysize: " + arraysize + " found: " + part + " expected: integer");
            }
        }
        return arrayShape;
    }
}

