/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable;

import ca.nrc.cadc.dali.tables.TableWriter;
import ca.nrc.cadc.dali.tables.votable.FieldElement;
import ca.nrc.cadc.dali.tables.votable.GroupElement;
import ca.nrc.cadc.dali.tables.votable.ParamElement;
import ca.nrc.cadc.dali.tables.votable.VOTableDocument;
import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.VOTableGroup;
import ca.nrc.cadc.dali.tables.votable.VOTableInfo;
import ca.nrc.cadc.dali.tables.votable.VOTableParam;
import ca.nrc.cadc.dali.tables.votable.VOTableResource;
import ca.nrc.cadc.dali.tables.votable.VOTableTable;
import ca.nrc.cadc.dali.tables.votable.XMLOutputProcessor;
import ca.nrc.cadc.dali.util.FormatFactory;
import ca.nrc.cadc.io.ResourceIterator;
import ca.nrc.cadc.xml.ContentConverter;
import ca.nrc.cadc.xml.MaxIterations;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class VOTableWriter
implements TableWriter<VOTableDocument> {
    private static final Logger log = Logger.getLogger(VOTableWriter.class);
    public static final String CONTENT_TYPE = "application/x-votable+xml";
    public static final String CONTENT_TYPE_ALT = "text/xml";
    public static final String SERIALIZATION_PARAM_BINARY2 = " ;serialization=binary2";
    public static final String SERIALIZATION_PARAM_TABLEDATA = "; serialization=tabledata";
    public static final String VOTABLE_VERSION = "1.4";
    public static final String XSI_SCHEMA = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String VOTABLE_11_NS_URI = "http://www.ivoa.net/xml/VOTable/v1.1";
    public static final String VOTABLE_12_NS_URI = "http://www.ivoa.net/xml/VOTable/v1.2";
    public static final String VOTABLE_13_NS_URI = "http://www.ivoa.net/xml/VOTable/v1.3";
    private FormatFactory formatFactory;
    private final String contentType;
    private final SerializationType serialization;

    public VOTableWriter() {
        this(SerializationType.TABLEDATA);
    }

    public VOTableWriter(SerializationType serialization) {
        if (serialization == null) {
            throw new IllegalArgumentException("serialization cannot be null");
        }
        this.serialization = serialization;
        switch (serialization) {
            case TABLEDATA: {
                this.contentType = "application/x-votable+xml; serialization=tabledata";
                break;
            }
            case BINARY2: {
                this.contentType = "application/x-votable+xml ;serialization=binary2";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported serialization type: " + serialization);
            }
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getErrorContentType() {
        return this.getContentType();
    }

    @Override
    public String getExtension() {
        return "xml";
    }

    @Override
    public void setFormatFactory(FormatFactory formatFactory) {
        this.formatFactory = formatFactory;
    }

    @Override
    public void write(VOTableDocument votable, OutputStream ostream) throws IOException {
        this.write(votable, ostream, (Long)Long.MAX_VALUE);
    }

    @Override
    public void write(VOTableDocument votable, OutputStream ostream, Long maxrec) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(ostream, "UTF-8"));
        this.write(votable, writer, maxrec);
    }

    public void write(VOTableDocument votable, Writer writer) throws IOException {
        this.write(votable, writer, (Long)Long.MAX_VALUE);
    }

    public void write(VOTableDocument votable, Writer writer, Long maxrec) throws IOException {
        if (this.formatFactory == null) {
            this.formatFactory = new FormatFactory();
        }
        this.writeImpl(votable, writer, maxrec);
    }

    @Override
    public void write(Throwable thrown, OutputStream output) throws IOException {
        Document document = this.createDocument();
        Element root = document.getRootElement();
        Namespace namespace = root.getNamespace();
        Element resource = new Element("RESOURCE", namespace);
        resource.setAttribute("type", "results");
        root.addContent((Content)resource);
        Element info = new Element("INFO", namespace);
        info.setAttribute("name", "QUERY_STATUS");
        info.setAttribute("value", "ERROR");
        info.setText(this.getThrownExceptions(thrown));
        resource.addContent((Content)info);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(document, output);
    }

    protected void writeImpl(VOTableDocument votable, Writer writer, Long maxrec) throws IOException {
        log.debug((Object)("write, maxrec=" + maxrec));
        Document document = this.createDocument();
        Element root = document.getRootElement();
        Namespace namespace = root.getNamespace();
        ResourceIterator<List<Object>> rowIter = null;
        List<VOTableField> fields = null;
        Element trailer = null;
        TabledataMaxIterations maxIterations = null;
        for (VOTableResource votResource : votable.getResources()) {
            Element resource = this.createResource(votResource, namespace);
            root.addContent((Content)resource);
            if (votResource.getTable() == null) continue;
            VOTableTable vot = votResource.getTable();
            Element table = new Element("TABLE", namespace);
            resource.addContent((Content)table);
            for (VOTableInfo tableInfo : vot.getInfos()) {
                table.addContent((Content)this.createInfo(tableInfo, namespace));
            }
            log.debug((Object)("wrote resource.table.info: " + vot.getInfos().size()));
            for (VOTableParam param : vot.getParams()) {
                table.addContent((Content)new ParamElement(param, namespace));
            }
            log.debug((Object)("wrote resource.table.param: " + vot.getParams().size()));
            for (VOTableField field : vot.getFields()) {
                table.addContent((Content)new FieldElement(field, namespace));
            }
            log.debug((Object)("wrote resource.table.field: " + vot.getFields().size()));
            if (vot.getTableData() != null) {
                Element data = new Element("DATA", namespace);
                table.addContent((Content)data);
                log.debug((Object)("setup content interator: maxrec=" + maxrec));
                trailer = new Element("INFO", namespace);
                trailer.setAttribute("name", "placeholder");
                trailer.setAttribute("value", "ignore");
                resource.addContent((Content)trailer);
                maxIterations = new TabledataMaxIterations(maxrec, trailer);
                rowIter = vot.getTableData().iterator();
                fields = vot.getFields();
                if (this.serialization.equals((Object)SerializationType.TABLEDATA)) {
                    log.debug((Object)"adding TABLEDATA element to DATA element");
                    Element tabledataElement = new Element("TABLEDATA", namespace);
                    data.addContent((Content)tabledataElement);
                    continue;
                }
                if (this.serialization.equals((Object)SerializationType.BINARY2)) {
                    log.debug((Object)"adding BINARY2 element to DATA element");
                    Element binary2 = new Element("BINARY2", namespace);
                    data.addContent((Content)binary2);
                    continue;
                }
                throw new RuntimeException("Invalid serialization type: " + this.serialization);
            }
            table.addContent((Content)new Comment("data goes here"));
        }
        for (VOTableInfo votableInfo : votable.getInfos()) {
            root.addContent((Content)this.createInfo(votableInfo, namespace));
        }
        try {
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            outputter.setXMLOutputProcessor((org.jdom2.output.support.XMLOutputProcessor)new XMLOutputProcessor((Iterator<List<Object>>)rowIter, fields, maxIterations, trailer, this.formatFactory));
            outputter.output(document, writer);
        }
        catch (RuntimeException ex) {
            log.error((Object)"OUTPUT FAIL", (Throwable)ex);
            throw ex;
        }
    }

    private Element createResource(VOTableResource votResource, Namespace namespace) {
        Element resource = new Element("RESOURCE", namespace);
        resource.setAttribute("type", votResource.getType());
        log.debug((Object)("wrote resource.type: " + votResource.getType()));
        if (votResource.id != null) {
            resource.setAttribute("ID", votResource.id);
        }
        if (votResource.getName() != null) {
            resource.setAttribute("name", votResource.getName());
        }
        if (votResource.utype != null) {
            resource.setAttribute("utype", votResource.utype);
        }
        if (votResource.description != null) {
            Element description = new Element("DESCRIPTION", namespace);
            description.setText(votResource.description);
            resource.addContent((Content)description);
        }
        for (VOTableInfo in : votResource.getInfos()) {
            resource.addContent((Content)this.createInfo(in, namespace));
        }
        log.debug((Object)("wrote resource.info: " + votResource.getInfos().size()));
        for (VOTableParam param : votResource.getParams()) {
            resource.addContent((Content)new ParamElement(param, namespace));
        }
        log.debug((Object)("wrote resource.param: " + votResource.getParams().size()));
        for (VOTableGroup vg : votResource.getGroups()) {
            resource.addContent((Content)new GroupElement(vg, namespace));
        }
        return resource;
    }

    protected Document createDocument() {
        Namespace vot = Namespace.getNamespace((String)VOTABLE_13_NS_URI);
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)XSI_SCHEMA);
        Element votable = new Element("VOTABLE", vot);
        votable.setAttribute("version", VOTABLE_VERSION);
        votable.addNamespaceDeclaration(xsi);
        Document document = new Document();
        document.addContent((Content)votable);
        return document;
    }

    private Element createInfo(VOTableInfo voTableInfo, Namespace namespace) {
        Element info = new Element("INFO", namespace);
        info.setAttribute("name", voTableInfo.getName());
        info.setAttribute("value", voTableInfo.getValue());
        if (voTableInfo.id != null) {
            info.setAttribute("ID", voTableInfo.id);
        }
        if (voTableInfo.content != null) {
            info.setText(voTableInfo.content);
        }
        return info;
    }

    private String getThrownExceptions(Throwable thrown) {
        StringBuilder sb = new StringBuilder();
        if (thrown.getMessage() == null) {
            sb.append("");
        } else {
            sb.append(thrown.getMessage());
        }
        while (thrown.getCause() != null) {
            thrown = thrown.getCause();
            sb.append(" ");
            if (thrown.getMessage() == null) {
                sb.append("");
                continue;
            }
            sb.append(thrown.getMessage());
        }
        return sb.toString();
    }

    private class TabledataContentConverter
    implements ContentConverter<Element, List<Object>> {
        private final List<VOTableField> fields;
        private final Namespace namespace;
        private final List<ca.nrc.cadc.dali.util.Format<Object>> formats;
        private final Element trailer;
        private boolean exceptionHandled = false;

        TabledataContentConverter(List<VOTableField> fields, Namespace namespace, Element trailer) {
            this.fields = fields;
            this.namespace = namespace;
            this.trailer = trailer;
            this.formats = new ArrayList<ca.nrc.cadc.dali.util.Format<Object>>(fields.size());
            for (VOTableField field : fields) {
                ca.nrc.cadc.dali.util.Format format = null;
                format = field.getFormat() == null ? VOTableWriter.this.formatFactory.getFormat(field) : field.getFormat();
                this.formats.add(format);
            }
        }

        public Element convert(List<Object> row) {
            if (row.size() != this.fields.size()) {
                throw new IllegalStateException("cannot write row: " + this.fields.size() + " metadata fields, " + row.size() + " data columns");
            }
            Element tr = new Element("TR", this.namespace);
            for (int i = 0; i < row.size(); ++i) {
                try {
                    Object o = row.get(i);
                    ca.nrc.cadc.dali.util.Format<Object> fmt = this.formats.get(i);
                    Element td = new Element("TD", this.namespace);
                    td.setText(fmt.format(o));
                    tr.addContent((Content)td);
                    continue;
                }
                catch (Exception ex) {
                    this.handleException(ex);
                    throw ex;
                }
            }
            return tr;
        }

        public void handleException(Exception ex) {
            if (!this.exceptionHandled) {
                log.debug((Object)"failure while iterating", (Throwable)ex);
                this.trailer.setAttribute("name", "QUERY_STATUS");
                this.trailer.setAttribute("value", "ERROR");
                this.trailer.setText(ex.toString());
            }
            this.exceptionHandled = true;
        }
    }

    private class TabledataMaxIterations
    implements MaxIterations {
        private final long maxRec;
        private final Element info;

        TabledataMaxIterations(Long maxRec, Element info) {
            this.maxRec = maxRec == null ? Long.MAX_VALUE : maxRec;
            this.info = info;
        }

        public long getMaxIterations() {
            return this.maxRec;
        }

        public void maxIterationsReached(boolean moreAvailable) {
            log.debug((Object)("TabledataMaxIterations.maxIterationsReached: " + this.maxRec + ", more=" + moreAvailable));
            if (moreAvailable) {
                this.info.setAttribute("name", "QUERY_STATUS");
                this.info.setAttribute("value", "OVERFLOW");
            }
        }
    }

    public static enum SerializationType {
        TABLEDATA,
        BINARY,
        BINARY2;


        public static boolean contains(String value) {
            SerializationType[] values;
            for (SerializationType serializationType : values = SerializationType.values()) {
                if (!serializationType.name().equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }

        public static SerializationType toValue(String str) {
            for (SerializationType serializationType : SerializationType.values()) {
                if (!serializationType.toString().equalsIgnoreCase(str)) continue;
                return serializationType;
            }
            throw new IllegalArgumentException("No Serialization Type found for : " + str);
        }
    }
}

