/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable.binary;

import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.binary.FieldProcessorFactory;
import ca.nrc.cadc.xml.MaxIterations;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class BinaryElementWriter {
    private static final Logger log = Logger.getLogger(BinaryElementWriter.class);
    private final FieldProcessorFactory decoderFactory = new FieldProcessorFactory();
    private final Iterator<List<Object>> rowIter;
    private final List<VOTableField> fields;
    private final MaxIterations maxIterations;
    private final Element trailer;

    public BinaryElementWriter(Iterator<List<Object>> rowIter, List<VOTableField> fields, MaxIterations maxIterations, Element trailer) {
        this.rowIter = rowIter;
        this.fields = fields;
        this.maxIterations = maxIterations;
        this.trailer = trailer;
    }

    public void write(Writer out) throws IOException {
        log.debug((Object)"Writing BINARY2 element - starting");
        out.write("<BINARY2><STREAM encoding=\"base64\">");
        long rowCount = 1L;
        try (OutputStream base64Out = Base64.getEncoder().wrap(new WriterOutputStream(out));){
            DataOutputStream dataOut = new DataOutputStream(base64Out);
            Iterator<List<Object>> iter = this.rowIter;
            while (iter.hasNext()) {
                List<Object> row = iter.next();
                try {
                    this.writeRow(row, dataOut);
                }
                catch (Exception ex) {
                    log.error((Object)("Error writing row " + rowCount + ": " + ex.getMessage()), (Throwable)ex);
                    this.trailer.setAttribute("name", "QUERY_STATUS");
                    this.trailer.setAttribute("value", "ERROR");
                    this.trailer.setText(ex.toString());
                }
                if (this.maxIterations != null && rowCount == this.maxIterations.getMaxIterations()) {
                    this.maxIterations.maxIterationsReached(iter.hasNext());
                    break;
                }
                ++rowCount;
            }
            dataOut.flush();
        }
        out.write("</STREAM></BINARY2>");
        log.debug((Object)("Finished writing BINARY2 element. Wrote " + (rowCount - 1L) + " rows"));
    }

    private void writeRow(List<Object> row, DataOutputStream out) throws IOException {
        int i;
        int numFields = this.fields.size();
        int numFlagBytes = (numFields + 7) / 8;
        byte[] nullFlags = new byte[numFlagBytes];
        for (i = 0; i < numFields; ++i) {
            if (row.get(i) != null) continue;
            int n = i / 8;
            nullFlags[n] = (byte)(nullFlags[n] | (byte)(1 << 7 - i % 8));
        }
        out.write(nullFlags);
        for (i = 0; i < numFields; ++i) {
            Object value = row.get(i);
            if (value == null) continue;
            this.decoderFactory.getFieldProcessor(this.fields.get(i).getDatatype().toLowerCase()).serialize(out, this.fields.get(i), value);
        }
    }

    static class WriterOutputStream
    extends OutputStream {
        private final Writer writer;

        WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            for (int i = off; i < off + len; ++i) {
                this.writer.write(b[i] & 0xFF);
            }
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }
    }
}

