/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable.binary;

import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.binary.BinaryRowReader;
import ca.nrc.cadc.dali.util.FormatFactory;
import ca.nrc.cadc.io.ResourceIterator;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.log4j.Logger;

public class BinaryIterator
implements ResourceIterator<List<Object>> {
    private static final Logger log = Logger.getLogger(BinaryIterator.class);
    private final DataInputStream in;
    private final BinaryRowReader binaryRowReader;
    private List<Object> nextRow;
    private boolean finished = false;

    public BinaryIterator(InputStream input, List<VOTableField> fields, String encoding, FormatFactory formatFactory, boolean isBinary2) {
        if ("gzip".equalsIgnoreCase(encoding)) {
            try {
                this.in = new DataInputStream(new GZIPInputStream(input));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create GZIPInputStream");
            }
        } else if ("base64".equalsIgnoreCase(encoding)) {
            this.in = new DataInputStream((InputStream)new Base64InputStream(input));
        } else {
            throw new IllegalArgumentException("Unsupported encoding: " + encoding);
        }
        this.binaryRowReader = new BinaryRowReader(fields, formatFactory, isBinary2);
        this.fetchNext();
    }

    public boolean hasNext() {
        return this.nextRow != null && !this.finished;
    }

    public List<Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more rows");
        }
        List<Object> current = this.nextRow;
        this.fetchNext();
        return current;
    }

    private void fetchNext() {
        try {
            this.nextRow = this.binaryRowReader.readRow(this.in);
            if (this.nextRow == null) {
                this.finished = true;
            }
        }
        catch (EOFException eof) {
            this.finished = true;
            this.nextRow = null;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading next row", (Throwable)e);
            this.finished = true;
            this.nextRow = null;
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void close() throws IOException {
        this.in.close();
    }
}

