/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable.tabledata;

import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.FormatFactory;
import ca.nrc.cadc.xml.MaxIterations;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class TableDataElementWriter {
    private static final Logger log = Logger.getLogger(TableDataElementWriter.class);
    private final Iterator<List<Object>> rowIter;
    private final List<VOTableField> fields;
    private final FormatFactory formatFactory;
    private final MaxIterations maxIterations;
    private final Element trailer;

    public TableDataElementWriter(Iterator<List<Object>> rowIter, List<VOTableField> fields, MaxIterations maxIterations, Element trailer, FormatFactory formatFactory) {
        this.rowIter = rowIter;
        this.fields = fields;
        this.maxIterations = maxIterations;
        this.trailer = trailer;
        this.formatFactory = formatFactory;
    }

    public void write(Writer out) throws IOException {
        log.debug((Object)"Writing TABLEDATA element - starting");
        out.write("<TABLEDATA>");
        long rowCount = 1L;
        while (this.rowIter.hasNext()) {
            List<Object> row = this.rowIter.next();
            this.writeRow(out, row);
            if (this.maxIterations != null && rowCount == this.maxIterations.getMaxIterations()) {
                this.maxIterations.maxIterationsReached(this.rowIter.hasNext());
                break;
            }
            ++rowCount;
        }
        out.write("</TABLEDATA>");
        log.debug((Object)("Finished writing TABLEDATA element. Wrote " + (rowCount - 1L) + " rows"));
    }

    private void writeRow(Writer out, List<Object> row) throws IOException {
        out.write("<TR>");
        for (int i = 0; i < row.size(); ++i) {
            Object value = row.get(i);
            Format fmt = this.formatFactory.getFormat(this.fields.get(i));
            if (value == null) {
                out.write("<TD/>");
                continue;
            }
            out.write("<TD>");
            try {
                out.write(TableDataElementWriter.escapeXml(fmt.format(value)));
            }
            catch (Exception ex) {
                this.trailer.setAttribute("name", "QUERY_STATUS");
                this.trailer.setAttribute("value", "ERROR");
                this.trailer.setText(ex.toString());
            }
            out.write("</TD>");
        }
        out.write("</TR>");
    }

    private static String escapeXml(String input) {
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }
}

