/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.util.DoubleFormat;
import ca.nrc.cadc.dali.util.Format;
import java.util.Iterator;

public class DoubleArrayFormat
implements Format<double[]> {
    private final DoubleFormat fmt = new DoubleFormat();

    @Override
    public String format(double[] object) {
        if (object == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (double d : object) {
            sb.append(Double.toString(d));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    @Override
    public String format(Iterator<Double> iter) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            Double d = iter.next();
            sb.append(this.fmt.format(d));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    @Override
    public double[] parse(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String[] tokens = s.split(" +");
        double[] array = new double[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String t = tokens[i];
            array[i] = this.fmt.parse(t);
        }
        return array;
    }
}

