/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.util.BooleanFormat;
import ca.nrc.cadc.dali.util.ByteArrayFormat;
import ca.nrc.cadc.dali.util.ByteFormat;
import ca.nrc.cadc.dali.util.CircleFormat;
import ca.nrc.cadc.dali.util.DefaultFormat;
import ca.nrc.cadc.dali.util.DoubleArray2DFormat;
import ca.nrc.cadc.dali.util.DoubleArrayFormat;
import ca.nrc.cadc.dali.util.DoubleFormat;
import ca.nrc.cadc.dali.util.DoubleIntervalArrayFormat;
import ca.nrc.cadc.dali.util.DoubleIntervalFormat;
import ca.nrc.cadc.dali.util.FloatArrayFormat;
import ca.nrc.cadc.dali.util.FloatFormat;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.IntArrayFormat;
import ca.nrc.cadc.dali.util.IntegerFormat;
import ca.nrc.cadc.dali.util.LongArrayFormat;
import ca.nrc.cadc.dali.util.LongFormat;
import ca.nrc.cadc.dali.util.LongIntervalFormat;
import ca.nrc.cadc.dali.util.MultiPolygonFormat;
import ca.nrc.cadc.dali.util.PointFormat;
import ca.nrc.cadc.dali.util.PolygonFormat;
import ca.nrc.cadc.dali.util.STCPositionFormat;
import ca.nrc.cadc.dali.util.STCRegionFormat;
import ca.nrc.cadc.dali.util.ShapeFormat;
import ca.nrc.cadc.dali.util.ShortArrayFormat;
import ca.nrc.cadc.dali.util.ShortFormat;
import ca.nrc.cadc.dali.util.StringFormat;
import ca.nrc.cadc.dali.util.URIFormat;
import ca.nrc.cadc.dali.util.UTCTimestampFormat;
import ca.nrc.cadc.dali.util.UUIDFormat;
import org.apache.log4j.Logger;

public class FormatFactory {
    private static final Logger log = Logger.getLogger(FormatFactory.class);

    public Format getFormat(VOTableField field) {
        String datatype = field.getDatatype();
        Format<Object> ret = new DefaultFormat();
        if (datatype == null) {
            ret = new DefaultFormat();
        } else if (datatype.equalsIgnoreCase("boolean")) {
            ret = new BooleanFormat();
        } else if (datatype.equalsIgnoreCase("bit")) {
            ret = FormatFactory.isArray(field) ? new ByteArrayFormat() : new ByteFormat();
        } else if (datatype.equalsIgnoreCase("unsignedByte")) {
            ret = FormatFactory.isArray(field) ? new ByteArrayFormat() : new ByteFormat();
        } else if (datatype.equalsIgnoreCase("short")) {
            ret = FormatFactory.isArray(field) ? ("interval".equalsIgnoreCase(field.xtype) ? new LongIntervalFormat() : new ShortArrayFormat()) : new ShortFormat(field.nullValue);
        } else if (datatype.equalsIgnoreCase("int")) {
            ret = FormatFactory.isArray(field) ? ("interval".equalsIgnoreCase(field.xtype) ? new LongIntervalFormat() : new IntArrayFormat()) : new IntegerFormat(field.nullValue);
        } else if (datatype.equalsIgnoreCase("long")) {
            ret = FormatFactory.isArray(field) ? ("interval".equalsIgnoreCase(field.xtype) ? new LongIntervalFormat() : new LongArrayFormat()) : new LongFormat(field.nullValue);
        } else if (datatype.equalsIgnoreCase("unicodeChar")) {
            ret = new StringFormat();
        } else if (datatype.equalsIgnoreCase("float")) {
            if (FormatFactory.isArray(field)) {
                if ("point".equalsIgnoreCase(field.xtype)) {
                    ret = new PointFormat();
                } else if ("circle".equalsIgnoreCase(field.xtype)) {
                    ret = new CircleFormat();
                } else if ("polygon".equalsIgnoreCase(field.xtype)) {
                    ret = new PolygonFormat();
                } else if ("multipolygon".equalsIgnoreCase(field.xtype)) {
                    ret = new MultiPolygonFormat();
                } else if ("interval".equalsIgnoreCase(field.xtype)) {
                    ret = new DoubleIntervalFormat();
                } else if (field.getArrayShape().length == 1) {
                    ret = new FloatArrayFormat();
                }
            } else {
                ret = new FloatFormat();
            }
        } else if (datatype.equalsIgnoreCase("double")) {
            if (FormatFactory.isArray(field)) {
                if ("point".equalsIgnoreCase(field.xtype)) {
                    ret = new PointFormat();
                } else if ("circle".equalsIgnoreCase(field.xtype)) {
                    ret = new CircleFormat();
                } else if ("polygon".equalsIgnoreCase(field.xtype)) {
                    ret = new PolygonFormat();
                } else if ("multipolygon".equalsIgnoreCase(field.xtype)) {
                    ret = new MultiPolygonFormat();
                } else if ("interval".equalsIgnoreCase(field.xtype)) {
                    if (field.getArrayShape().length == 1 && field.getArrayShape()[0] == 2) {
                        ret = new DoubleIntervalFormat();
                    } else if (field.getArrayShape().length == 2 && field.getArrayShape()[0] == 2) {
                        ret = new DoubleIntervalArrayFormat();
                    }
                } else if (field.getArrayShape().length == 1) {
                    ret = new DoubleArrayFormat();
                } else if (field.getArrayShape().length == 2) {
                    ret = new DoubleArray2DFormat(field.getArrayShape());
                }
            } else {
                ret = new DoubleFormat();
            }
        } else {
            if (datatype.equalsIgnoreCase("floatComplex")) {
                throw new UnsupportedOperationException("floatComplex datatype not supported for column " + field.getName());
            }
            if (datatype.equalsIgnoreCase("doubleComplex")) {
                throw new UnsupportedOperationException("doubleComplex datatype not supported for column " + field.getName());
            }
            if (datatype.equalsIgnoreCase("char") && FormatFactory.isArray(field)) {
                if ("timestamp".equalsIgnoreCase(field.xtype)) {
                    ret = new UTCTimestampFormat();
                } else if (field.xtype != null && field.xtype.endsWith("shape")) {
                    ret = new ShapeFormat();
                } else if ("adql:timestamp".equalsIgnoreCase(field.xtype)) {
                    ret = new UTCTimestampFormat();
                } else if ("adql:point".equalsIgnoreCase(field.xtype)) {
                    ret = new STCPositionFormat();
                } else if ("adql:region".equalsIgnoreCase(field.xtype)) {
                    ret = new STCRegionFormat();
                } else if ("uuid".equalsIgnoreCase(field.xtype)) {
                    ret = new UUIDFormat();
                } else if ("uri".equalsIgnoreCase(field.xtype)) {
                    ret = new URIFormat();
                }
            }
        }
        log.debug((Object)(field + " formatter: " + ret.getClass().getName()));
        return ret;
    }

    private static boolean isArray(VOTableField field) {
        return field.getArrayShape() != null;
    }
}

