/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.date.DateUtil;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public class LocalTimestampFormat
implements Format<Date> {
    private DateFormat dateFormat = DateUtil.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)DateUtil.LOCAL);

    @Override
    public String format(Date object) {
        if (object == null) {
            return "";
        }
        Date date = null;
        if (object instanceof Date) {
            date = object;
        }
        if (object instanceof java.sql.Date) {
            date = DateUtil.toDate((Object)object);
        }
        if (object instanceof Timestamp) {
            date = DateUtil.toDate((Object)object);
        }
        if (date != null) {
            return this.dateFormat.format(date);
        }
        throw new UnsupportedOperationException("formatting " + object.getClass().getName() + " " + object);
    }

    @Override
    public Date parse(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return DateUtil.flexToDate((String)s, (DateFormat)this.dateFormat);
        }
        catch (ParseException ex) {
            throw new UnsupportedOperationException("Unable to parse to a Date " + s);
        }
    }
}

