/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.Polygon;
import ca.nrc.cadc.dali.util.DoubleArrayFormat;
import ca.nrc.cadc.dali.util.Format;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class PolygonFormat
implements Format<Polygon> {
    private static final Logger log = Logger.getLogger(PolygonFormat.class);
    private final DoubleArrayFormat fmt = new DoubleArrayFormat();

    @Override
    public Polygon parse(String s) {
        if (s == null) {
            return null;
        }
        double[] dd = this.fmt.parse(s);
        try {
            Polygon poly = new Polygon();
            for (int i = 0; i < dd.length; i += 2) {
                if (Double.isNaN(dd[i]) || Double.isNaN(dd[i + 1])) {
                    throw new IllegalArgumentException("invalid polygon (NaN coordinate value): " + s);
                }
                Point v = new Point(dd[i], dd[i + 1]);
                poly.getVertices().add(v);
            }
            if (poly.getVertices().size() < 3) {
                throw new IllegalArgumentException("invalid polygon (not enough points): " + s);
            }
            return poly;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("invalid polygon (odd number of coordinate values): " + s);
        }
    }

    @Override
    public String format(final Polygon poly) {
        if (poly == null) {
            return "";
        }
        return this.fmt.format(new Iterator<Double>(){
            private int num = 0;
            private int numP = 0;

            @Override
            public boolean hasNext() {
                return this.numP < poly.getVertices().size();
            }

            @Override
            public Double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Point p = poly.getVertices().get(this.numP);
                if (this.num == 0) {
                    ++this.num;
                    return p.getLongitude();
                }
                ++this.numP;
                this.num = 0;
                return p.getLatitude();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }
}

