/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.Circle;
import ca.nrc.cadc.dali.Polygon;
import ca.nrc.cadc.dali.Range;
import ca.nrc.cadc.dali.Shape;
import ca.nrc.cadc.dali.util.CircleFormat;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.PointFormat;
import ca.nrc.cadc.dali.util.PolygonFormat;
import ca.nrc.cadc.dali.util.RangeFormat;
import org.apache.log4j.Logger;

public class ShapeFormat
implements Format<Shape> {
    private static final Logger log = Logger.getLogger(ShapeFormat.class);
    private final PointFormat pointF = new PointFormat();
    private final CircleFormat circleF = new CircleFormat();
    private final PolygonFormat polyF = new PolygonFormat();
    private final RangeFormat rangeF;

    public ShapeFormat() {
        this(false);
    }

    public ShapeFormat(boolean supportSIA2) {
        this.rangeF = new RangeFormat(supportSIA2);
    }

    @Override
    public Shape parse(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        String[] parts = ShapeFormat.separateKey(s);
        if (Circle.class.getSimpleName().equalsIgnoreCase(parts[0])) {
            return this.circleF.parse(parts[1]);
        }
        if (Range.class.getSimpleName().equalsIgnoreCase(parts[0])) {
            return this.rangeF.parse(parts[1]);
        }
        if (Polygon.class.getSimpleName().equalsIgnoreCase(parts[0])) {
            return this.polyF.parse(parts[1]);
        }
        throw new IllegalArgumentException("unexpected shape: " + parts[0]);
    }

    @Override
    public String format(Shape t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t.getClass().getSimpleName().toLowerCase()).append(" ");
        if (t instanceof Circle) {
            sb.append(this.circleF.format((Circle)t));
        } else if (t instanceof Range) {
            sb.append(this.rangeF.format((Range)t));
        } else if (t instanceof Polygon) {
            sb.append(this.polyF.format((Polygon)t));
        } else {
            throw new IllegalArgumentException("unsupported shape: " + t.getClass().getName());
        }
        return sb.toString();
    }

    public static String[] separateKey(String s) {
        String[] ret = new String[2];
        int i = s.indexOf(" ");
        if (i > 0) {
            ret[0] = s.substring(0, i);
            if (i + 1 < s.length() - 1) {
                ret[1] = s.substring(i + 1, s.length());
            }
            return ret;
        }
        ret[0] = s;
        return ret;
    }
}

