/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc;

public enum SpectralUnit {
    Hz("Hz"),
    MHz("MHz"),
    GHz("GHz"),
    m("m"),
    mm("mm"),
    um("um"),
    nm("nm"),
    Angstrom("Angstrom"),
    eV("eV"),
    keV("keV"),
    MeV("MeV");

    private String value;

    private SpectralUnit(String value) {
        this.value = value;
    }

    public static SpectralUnit toValue(String s) {
        for (SpectralUnit v : SpectralUnit.values()) {
            if (!v.toString().equalsIgnoreCase(s)) continue;
            return v;
        }
        throw new IllegalArgumentException("No spectral unit named " + s);
    }

    public String getValue() {
        return this.value;
    }

    public static boolean contains(String v) {
        SpectralUnit[] values = SpectralUnit.values();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].value.equals(v)) continue;
            return true;
        }
        return false;
    }
}

