/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.Circle;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.util.Format;
import ca.nrc.cadc.stc.util.RegionFormat;

public class CircleFormat
extends RegionFormat
implements Format<Circle> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Circle parse(String phrase) throws StcsParsingException {
        this.parseRegion(phrase);
        Double x = null;
        if (this.currentWord == null) {
            if (!this.words.hasNextDouble()) {
                if (!this.words.hasNext()) throw new StcsParsingException("Unexpected end to STC-S phrase before CoordPair element");
                throw new StcsParsingException("Invalid CoordPair element " + this.words.next());
            }
            x = this.words.nextDouble();
        } else {
            try {
                x = Double.valueOf(this.currentWord);
            }
            catch (NumberFormatException e) {
                throw new StcsParsingException("Invalid CoordPair " + this.currentWord + " in " + phrase);
            }
        }
        if (!this.words.hasNextDouble()) throw new StcsParsingException("Coordpair not found in " + phrase);
        double y = this.words.nextDouble();
        if (!this.words.hasNextDouble()) throw new StcsParsingException("Radius not found in " + phrase);
        double radius = this.words.nextDouble();
        return new Circle(this.frame, this.refpos, this.flavor, x, y, radius);
    }

    @Override
    public String format(Circle circle) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatRegion(circle));
        sb.append(" ");
        sb.append(circle.getCoordPair());
        sb.append(" ");
        sb.append(circle.getRadius());
        return sb.toString().trim();
    }
}

