/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.Not;
import ca.nrc.cadc.stc.Region;
import ca.nrc.cadc.stc.STC;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.util.Format;
import ca.nrc.cadc.stc.util.RegionFormat;

public class NotFormat
extends RegionFormat
implements Format<Not> {
    @Override
    public Not parse(String phrase) throws StcsParsingException {
        int open = phrase.indexOf("(");
        int close = phrase.lastIndexOf(")");
        if (open == -1 || close == -1) {
            throw new StcsParsingException("Not arguments must be enclosed in parentheses: " + phrase);
        }
        String not = phrase.substring(open + 1, close).trim();
        if (not.isEmpty()) {
            throw new StcsParsingException("Not must contain a Region: " + phrase);
        }
        Region region = STC.parse(not);
        return new Not(region);
    }

    @Override
    public String format(Not not) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatRegion(not));
        sb.append(" ( ");
        sb.append(STC.format(not.getRegion()));
        sb.append(" )");
        return sb.toString().trim();
    }
}

