/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.SpectralInterval;
import ca.nrc.cadc.stc.SpectralUnit;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.util.Format;

public class SpectralIntervalFormat
implements Format<SpectralInterval> {
    @Override
    public SpectralInterval parse(String phrase) throws StcsParsingException {
        double hilimit;
        double lolimit;
        if (phrase == null || phrase.length() == 0) {
            return null;
        }
        String[] tokens = (phrase = phrase.trim()).split("\\s+");
        if (tokens.length != 4) {
            throw new StcsParsingException("Expected 4 words in " + phrase);
        }
        if (!tokens[0].equalsIgnoreCase(SpectralInterval.NAME)) {
            throw new StcsParsingException("Expected SpectralInterval, was " + tokens[0]);
        }
        try {
            lolimit = Double.parseDouble(tokens[1]);
        }
        catch (NumberFormatException e) {
            throw new StcsParsingException("Unable to parse loLimit " + tokens[1] + " to number because " + e.getMessage());
        }
        try {
            hilimit = Double.parseDouble(tokens[2]);
        }
        catch (NumberFormatException e) {
            throw new StcsParsingException("Unable to parse hiLimit " + tokens[2] + " to number because " + e.getMessage());
        }
        if (!SpectralUnit.contains(tokens[3])) {
            throw new StcsParsingException("Not a valid SpectralUnit " + tokens[3]);
        }
        SpectralUnit unit = SpectralUnit.valueOf(tokens[3]);
        return new SpectralInterval(lolimit, hilimit, unit);
    }

    @Override
    public String format(SpectralInterval spectralInterval) {
        StringBuilder sb = new StringBuilder();
        sb.append(SpectralInterval.NAME);
        sb.append(" ");
        sb.append(spectralInterval.getLoLimit());
        sb.append(" ");
        sb.append(spectralInterval.getHiLimit());
        sb.append(" ");
        sb.append(spectralInterval.getUnit().getValue());
        return sb.toString();
    }
}

