/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.Region;
import ca.nrc.cadc.stc.Regions;
import ca.nrc.cadc.stc.STC;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.Union;
import ca.nrc.cadc.stc.util.Format;
import ca.nrc.cadc.stc.util.RegionFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UnionFormat
extends RegionFormat
implements Format<Union> {
    @Override
    public Union parse(String phrase) throws StcsParsingException {
        this.parseRegion(phrase);
        int open = phrase.indexOf("(");
        int close = phrase.lastIndexOf(")");
        if (open == -1 || close == -1) {
            throw new StcsParsingException("Union arguments must be enclosed in parentheses: " + phrase);
        }
        String union = phrase.substring(open + 1, close).trim();
        List<String> phrases = this.getRegions(union);
        ArrayList<Region> regions = new ArrayList<Region>(phrases.size());
        for (String s : phrases) {
            regions.add(STC.parse(s));
        }
        if (regions.size() < 2) {
            throw new StcsParsingException("Union must contain 2 or more regions: " + phrase);
        }
        return new Union(this.frame, this.refpos, this.flavor, regions);
    }

    @Override
    public String format(Union union) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatRegion(union));
        sb.append(" ( ");
        for (Region r : union.getRegions()) {
            sb.append(STC.format(r));
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString().trim();
    }

    private List<String> getRegions(String subPhrase) {
        String upperPhrase = subPhrase.toUpperCase();
        ArrayList<String> phrases = new ArrayList<String>();
        int index = -1;
        int start = 0;
        int end = 0;
        while (start != -1) {
            end = index = this.findRegion(upperPhrase, index);
            if (start != -1 && end > start) {
                phrases.add(subPhrase.substring(start, end));
            } else if (start != -1 && end == -1) {
                phrases.add(subPhrase.substring(start));
            }
            start = index++;
        }
        return phrases;
    }

    private int findRegion(String s, int start) {
        String upper = s.toUpperCase();
        Regions[] candidates = Regions.values();
        int[] indexes = new int[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            indexes[i] = upper.indexOf(candidates[i].name(), start);
        }
        Arrays.sort(indexes);
        int index = -1;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == -1) continue;
            index = indexes[i];
            break;
        }
        return index;
    }
}

