/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOUtils {
    private static final Map<List<Object>, String> resourceMap_ = new HashMap<List<Object>, String>();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.util");
    private static final byte[] lineSep_ = IOUtils.getLineSeparatorBytes();

    private IOUtils() {
    }

    public static void skipBytes(DataInput strm, long nskip) throws IOException {
        if (nskip < 0L) {
            throw new IllegalArgumentException("Can't skip backwards");
        }
        boolean hasSkipped = false;
        while (nskip > 0L) {
            int iskip;
            int jskip = (int)Math.min(nskip, Integer.MAX_VALUE);
            try {
                iskip = strm instanceof InputStream ? (int)((InputStream)((Object)strm)).skip(jskip) : strm.skipBytes(jskip);
                hasSkipped = true;
            }
            catch (IOException e) {
                if (!hasSkipped && !(e instanceof EOFException)) {
                    logger_.warning("Input stream does not support seeks??");
                }
                throw e;
            }
            if (iskip == 0) {
                strm.readByte();
                iskip = 1;
            }
            nskip -= (long)iskip;
        }
    }

    public static void skip(InputStream strm, long nskip) throws IOException {
        long iskip;
        if (nskip < 0L) {
            throw new IllegalArgumentException("Can't skip backwards");
        }
        if (nskip == 0L) {
            return;
        }
        boolean hasSkipped = false;
        for (long nskip1 = nskip - 1L; nskip1 > 0L; nskip1 -= iskip) {
            try {
                iskip = strm.skip(nskip1);
                hasSkipped = true;
            }
            catch (IOException e) {
                if (!hasSkipped && !(e instanceof EOFException)) {
                    logger_.warning("Input stream does not support seeks??");
                }
                throw e;
            }
            if (iskip != 0L) continue;
            if (strm.read() == -1) {
                throw new EOFException();
            }
            iskip = 1L;
        }
        if (strm.read() == -1) {
            throw new EOFException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceContents(Class<?> clazz, String name, Level level) {
        List<Object> key = Arrays.asList(clazz, name);
        if (!resourceMap_.containsKey(key)) {
            String value = null;
            InputStream in = null;
            try {
                in = clazz.getResourceAsStream(name);
                if (in != null) {
                    int b;
                    StringBuffer sbuf = new StringBuffer();
                    while ((b = in.read()) > 0) {
                        sbuf.append((char)b);
                    }
                    value = sbuf.toString().trim();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (value == null) {
                logger_.log(level == null ? Level.WARNING : level, "Couldn't read requested resource " + name);
                value = "?";
            }
            resourceMap_.put(key, value);
        }
        return resourceMap_.get(key);
    }

    public static void println(OutputStream out, String line) throws IOException {
        out.write(line.getBytes());
        out.write(lineSep_);
    }

    public static byte[] getLineSeparatorBytes() {
        try {
            return System.getProperty("line.separator", "\n").getBytes();
        }
        catch (SecurityException e) {
            return "\n".getBytes();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        int bufsiz = 8096;
        byte[] buf = new byte[bufsiz];
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
        }
    }

    public static byte[] readBytes(InputStream in, int maxLeng) throws IOException {
        int ngot;
        byte[] buf = new byte[maxLeng];
        int pos = 0;
        while (maxLeng - pos > 0 && (ngot = in.read(buf, pos, maxLeng - pos)) > 0) {
            pos += ngot;
        }
        if (pos < maxLeng) {
            byte[] buf2 = new byte[pos];
            System.arraycopy(buf, 0, buf2, 0, pos);
            buf = buf2;
        }
        return buf;
    }
}

