/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import uk.ac.starlink.votable.NumericDecoder;

public class BitDecoder
extends NumericDecoder {
    public BitDecoder(Class<?> clazz, long[] arraysize) {
        super(clazz, arraysize, -1);
    }

    public BitDecoder(long[] arraysize) {
        this(boolean[].class, arraysize);
    }

    @Override
    public boolean isNull(Object array, int index) {
        return false;
    }

    @Override
    public Object decodeStream(DataInput strm) throws IOException {
        int num = this.getNumItems(strm);
        boolean[] result = new boolean[num];
        int ibit = 0;
        int b = 0;
        for (int i = 0; i < num; ++i) {
            if (ibit == 0) {
                ibit = 8;
                b = strm.readByte();
            }
            result[i] = (b & 0x80) != 0;
            b <<= 1;
            --ibit;
        }
        return result;
    }

    @Override
    public void skipStream(DataInput strm) throws IOException {
        int num = this.getNumItems(strm);
        BitDecoder.skipBytes(strm, (num + 7) / 8);
    }

    @Override
    void setNullValue(String txt) {
    }

    @Override
    void setBad1(Object array, int index) {
    }

    @Override
    void decodeStream1(Object array, int index, DataInput strm) {
        throw new AssertionError((Object)"Can't get here");
    }

    @Override
    Object getEmptyArray(int size) {
        return new boolean[size];
    }

    @Override
    void decodeString1(Object array, int index, String txt) {
        ((boolean[])array)[index] = txt.length() > 0 && txt.charAt(0) == '1';
    }

    static BitDecoder createScalarBitDecoder() {
        return new BitDecoder((Class)Boolean.class, SCALAR_SIZE){

            @Override
            Object packageArray(Object array) {
                boolean[] arr = (boolean[])array;
                return this.isNull(arr, 0) ? null : Boolean.valueOf(arr[0]);
            }
        };
    }
}

