/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import uk.ac.starlink.votable.NumericDecoder;

public class BooleanDecoder
extends NumericDecoder {
    public BooleanDecoder(Class<?> clazz, long[] arraysize) {
        super(clazz, arraysize, 1);
    }

    public BooleanDecoder(long[] arraysize) {
        this(boolean[].class, arraysize);
    }

    @Override
    public boolean isNull(Object array, int index) {
        return false;
    }

    @Override
    void setNullValue(String txt) {
    }

    @Override
    Object getEmptyArray(int size) {
        return new boolean[size];
    }

    @Override
    void decodeString1(Object array, int index, String txt) {
        int leng = txt.length();
        Boolean flag = null;
        block4: for (int i = 0; flag == null && i < leng; ++i) {
            switch (txt.charAt(i)) {
                case '1': 
                case 'T': 
                case 't': {
                    flag = Boolean.TRUE;
                    continue block4;
                }
                case '0': 
                case 'F': 
                case 'f': {
                    flag = Boolean.FALSE;
                }
            }
        }
        ((boolean[])array)[index] = flag == Boolean.TRUE;
    }

    @Override
    void decodeStream1(Object array, int index, DataInput strm) throws IOException {
        boolean flag;
        switch (0xFF & (char)strm.readByte()) {
            case 49: 
            case 84: 
            case 116: {
                flag = true;
                break;
            }
            default: {
                flag = false;
            }
        }
        ((boolean[])array)[index] = flag;
    }

    @Override
    void setBad1(Object array, int index) {
    }

    static BooleanDecoder createScalarBooleanDecoder() {
        return new BooleanDecoder((Class)Boolean.class, SCALAR_SIZE){

            private Boolean decodeChar(char c) {
                switch (c) {
                    case '1': 
                    case 'T': 
                    case 't': {
                        return Boolean.TRUE;
                    }
                    case '0': 
                    case 'F': 
                    case 'f': {
                        return Boolean.FALSE;
                    }
                    case '\u0000': 
                    case ' ': 
                    case '?': {
                        return null;
                    }
                }
                return null;
            }

            @Override
            public Object decodeString(String txt) {
                int nchar = txt.length();
                if (nchar == 0) {
                    return null;
                }
                if (nchar == 1) {
                    return this.decodeChar(txt.charAt(0));
                }
                if (txt.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (txt.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                return null;
            }

            @Override
            public Object decodeStream(DataInput strm) throws IOException {
                return this.decodeChar((char)(0xFF & (char)strm.readByte()));
            }
        };
    }
}

