/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import java.util.StringTokenizer;
import uk.ac.starlink.votable.Decoder;

public abstract class NumericDecoder
extends Decoder {
    private final int size1_;

    public NumericDecoder(Class<?> clazz, long[] arraysize, int size1) {
        super(clazz, arraysize);
        this.size1_ = size1;
    }

    abstract Object getEmptyArray(int var1);

    abstract void setBad1(Object var1, int var2);

    abstract void decodeString1(Object var1, int var2, String var3);

    abstract void decodeStream1(Object var1, int var2, DataInput var3) throws IOException;

    Object packageArray(Object array) {
        return array;
    }

    @Override
    public Object decodeString(String txt) {
        StringTokenizer st = new StringTokenizer(txt);
        int ntok = st.countTokens();
        int ncell = this.numCells(ntok);
        Object result = this.getEmptyArray(ncell);
        for (int i = 0; i < ncell; ++i) {
            if (i < ntok) {
                String tok = st.nextToken().trim();
                if (!tok.equals(this.blankString)) {
                    try {
                        this.decodeString1(result, i, tok);
                    }
                    catch (IllegalArgumentException e) {
                        this.setBad1(result, i);
                    }
                    continue;
                }
                this.setBad1(result, i);
                continue;
            }
            this.setBad1(result, i);
        }
        return this.packageArray(result);
    }

    @Override
    public Object decodeStream(DataInput strm) throws IOException {
        int num = this.getNumItems(strm);
        Object result = this.getEmptyArray(num);
        for (int i = 0; i < num; ++i) {
            this.decodeStream1(result, i, strm);
        }
        return this.packageArray(result);
    }

    @Override
    public void skipStream(DataInput strm) throws IOException {
        int num = this.getNumItems(strm);
        NumericDecoder.skipBytes(strm, num * this.size1_);
    }

    Object scalarDecodeString(String txt) {
        if (txt == null || txt.length() == 0) {
            return null;
        }
        Object array = this.getEmptyArray(1);
        try {
            this.decodeString1(array, 0, txt.trim());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.packageArray(array);
    }

    static short parseShort(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'x' && txt.charAt(pos) == '0') {
            return Short.parseShort(txt.substring(pos + 2), 16);
        }
        return Short.parseShort(txt);
    }

    static int parseInt(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'x' && txt.charAt(pos) == '0') {
            return Integer.parseInt(txt.substring(pos + 2), 16);
        }
        return Integer.parseInt(txt);
    }

    static long parseLong(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'x' && txt.charAt(pos) == '0') {
            return Long.parseLong(txt.substring(pos + 2), 16);
        }
        return Long.parseLong(txt);
    }

    static float parseFloat(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos == 0) {
            return Float.NaN;
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'I' && txt.indexOf("Inf") == 1) {
            return txt.charAt(pos) == '-' ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        return Float.parseFloat(txt);
    }

    static double parseDouble(String txt) {
        int pos;
        int leng = txt.length();
        for (pos = 0; pos < leng && txt.charAt(pos) == ' '; ++pos) {
        }
        if (leng - pos == 0) {
            return Double.NaN;
        }
        if (leng - pos > 1 && txt.charAt(pos + 1) == 'I' && txt.indexOf("Inf") == 1) {
            return txt.charAt(pos) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return Double.parseDouble(txt);
    }

    static class ScalarDoubleDecoder
    extends DoubleDecoder {
        ScalarDoubleDecoder() {
            super(Double.class, SCALAR_SIZE);
        }

        @Override
        Object packageArray(Object array) {
            double[] arr = (double[])array;
            return this.isNull(arr, 0) ? null : new Double(arr[0]);
        }

        @Override
        public Object decodeString(String txt) {
            return this.scalarDecodeString(txt);
        }
    }

    static class DoubleDecoder
    extends NumericDecoder {
        DoubleDecoder(Class<?> clazz, long[] arraysize) {
            super(clazz, arraysize, 8);
        }

        DoubleDecoder(long[] arraysize) {
            this(double[].class, arraysize);
        }

        @Override
        void setNullValue(String txt) {
        }

        @Override
        Object getEmptyArray(int size) {
            return new double[size];
        }

        @Override
        void decodeString1(Object array, int index, String txt) {
            ((double[])array)[index] = DoubleDecoder.parseDouble(txt);
        }

        @Override
        void decodeStream1(Object array, int index, DataInput strm) throws IOException {
            ((double[])array)[index] = strm.readDouble();
        }

        @Override
        void setBad1(Object array, int index) {
            ((double[])array)[index] = Double.NaN;
        }

        @Override
        public boolean isNull(Object array, int index) {
            return Double.isNaN(((double[])array)[index]);
        }
    }

    static class ScalarFloatDecoder
    extends FloatDecoder {
        ScalarFloatDecoder() {
            super(Float.class, SCALAR_SIZE);
        }

        @Override
        Object packageArray(Object array) {
            float[] arr = (float[])array;
            return this.isNull(arr, 0) ? null : new Float(arr[0]);
        }

        @Override
        public Object decodeString(String txt) {
            return this.scalarDecodeString(txt);
        }
    }

    static class FloatDecoder
    extends NumericDecoder {
        FloatDecoder(Class<?> clazz, long[] arraysize) {
            super(clazz, arraysize, 4);
        }

        FloatDecoder(long[] arraysize) {
            this(float[].class, arraysize);
        }

        @Override
        void setNullValue(String txt) {
        }

        @Override
        Object getEmptyArray(int size) {
            return new float[size];
        }

        @Override
        void decodeString1(Object array, int index, String txt) {
            ((float[])array)[index] = FloatDecoder.parseFloat(txt);
        }

        @Override
        void decodeStream1(Object array, int index, DataInput strm) throws IOException {
            ((float[])array)[index] = strm.readFloat();
        }

        @Override
        void setBad1(Object array, int index) {
            ((float[])array)[index] = Float.NaN;
        }

        @Override
        public boolean isNull(Object array, int index) {
            return Float.isNaN(((float[])array)[index]);
        }
    }

    static class ScalarLongDecoder
    extends LongDecoder {
        ScalarLongDecoder() {
            super(Long.class, SCALAR_SIZE);
        }

        @Override
        Object packageArray(Object array) {
            long[] arr = (long[])array;
            return this.isNull(arr, 0) ? null : new Long(arr[0]);
        }

        @Override
        public Object decodeString(String txt) {
            return this.scalarDecodeString(txt);
        }
    }

    static class LongDecoder
    extends NumericDecoder {
        private long bad;
        private boolean hasBad = false;

        LongDecoder(Class<?> clazz, long[] arraysize) {
            super(clazz, arraysize, 8);
        }

        LongDecoder(long[] arraysize) {
            this(long[].class, arraysize);
        }

        @Override
        void setNullValue(String txt) {
            this.bad = LongDecoder.parseLong(txt);
            this.hasBad = true;
        }

        @Override
        Object getEmptyArray(int size) {
            return new long[size];
        }

        @Override
        void decodeString1(Object array, int index, String txt) {
            ((long[])array)[index] = LongDecoder.parseLong(txt);
        }

        @Override
        void decodeStream1(Object array, int index, DataInput strm) throws IOException {
            ((long[])array)[index] = strm.readLong();
        }

        @Override
        void setBad1(Object array, int index) {
            ((long[])array)[index] = this.bad;
        }

        @Override
        public boolean isNull(Object array, int index) {
            return this.hasBad && ((long[])array)[index] == this.bad;
        }
    }

    static class ScalarIntDecoder
    extends IntDecoder {
        ScalarIntDecoder() {
            super(Integer.class, SCALAR_SIZE);
        }

        @Override
        Object packageArray(Object array) {
            int[] arr = (int[])array;
            return this.isNull(arr, 0) ? null : Integer.valueOf(arr[0]);
        }

        @Override
        public Object decodeString(String txt) {
            return this.scalarDecodeString(txt);
        }
    }

    static class IntDecoder
    extends NumericDecoder {
        private int bad;
        private boolean hasBad = false;

        IntDecoder(Class<?> clazz, long[] arraysize) {
            super(clazz, arraysize, 4);
        }

        IntDecoder(long[] arraysize) {
            this(int[].class, arraysize);
        }

        @Override
        void setNullValue(String txt) {
            this.bad = IntDecoder.parseInt(txt);
            this.hasBad = true;
        }

        @Override
        Object getEmptyArray(int size) {
            return new int[size];
        }

        @Override
        void decodeString1(Object array, int index, String txt) {
            ((int[])array)[index] = IntDecoder.parseInt(txt);
        }

        @Override
        void decodeStream1(Object array, int index, DataInput strm) throws IOException {
            ((int[])array)[index] = strm.readInt();
        }

        @Override
        void setBad1(Object array, int index) {
            ((int[])array)[index] = this.bad;
        }

        @Override
        public boolean isNull(Object array, int index) {
            return this.hasBad && ((int[])array)[index] == this.bad;
        }
    }

    static class ScalarUnsignedByteDecoder
    extends UnsignedByteDecoder {
        ScalarUnsignedByteDecoder() {
            super(Short.class, SCALAR_SIZE);
        }

        @Override
        Object packageArray(Object array) {
            short[] arr = (short[])array;
            return this.isNull(arr, 0) ? null : new Short(arr[0]);
        }

        @Override
        public Object decodeString(String txt) {
            return this.scalarDecodeString(txt);
        }
    }

    static class UnsignedByteDecoder
    extends ShortDecoder {
        UnsignedByteDecoder(Class<?> clazz, long[] arraysize) {
            super(clazz, arraysize, 1);
        }

        UnsignedByteDecoder(long[] arraysize) {
            this(short[].class, arraysize);
        }

        @Override
        void decodeStream1(Object array, int index, DataInput strm) throws IOException {
            ((short[])array)[index] = (short)(0xFF & (short)strm.readByte());
        }
    }

    static class ScalarShortDecoder
    extends ShortDecoder {
        ScalarShortDecoder() {
            super(Short.class, SCALAR_SIZE, 2);
        }

        @Override
        Object packageArray(Object array) {
            short[] arr = (short[])array;
            return this.isNull(arr, 0) ? null : Short.valueOf(arr[0]);
        }

        @Override
        public Object decodeString(String txt) {
            return this.scalarDecodeString(txt);
        }
    }

    static class ShortDecoder
    extends NumericDecoder {
        private short bad;
        private boolean hasBad = false;

        ShortDecoder(long[] arraysize) {
            this(short[].class, arraysize, 2);
        }

        ShortDecoder(Class<?> clazz, long[] arraysize, int size1) {
            super(clazz, arraysize, size1);
        }

        @Override
        void setNullValue(String txt) {
            this.bad = ShortDecoder.parseShort(txt);
            this.hasBad = true;
        }

        @Override
        Object getEmptyArray(int size) {
            return new short[size];
        }

        @Override
        void decodeString1(Object array, int index, String txt) {
            ((short[])array)[index] = ShortDecoder.parseShort(txt);
        }

        @Override
        void decodeStream1(Object array, int index, DataInput strm) throws IOException {
            ((short[])array)[index] = strm.readShort();
        }

        @Override
        void setBad1(Object array, int index) {
            ((short[])array)[index] = this.bad;
        }

        @Override
        public boolean isNull(Object array, int index) {
            return this.hasBad && ((short[])array)[index] == this.bad;
        }
    }
}

