/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.dali.Circle;
import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.Polygon;
import org.apache.log4j.Logger;

class CartesianTransform {
    private static final Logger log = Logger.getLogger(CartesianTransform.class);
    static final double[] NEG_X_AXIS = new double[]{-1.0, 0.0, 0.0};
    static final double[] POS_X_AXIS = new double[]{1.0, 0.0, 0.0};
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    double angle;
    String axis;

    private CartesianTransform() {
    }

    public static CartesianTransform getTransform(Polygon poly) {
        return CartesianTransform.getTransform(poly, false);
    }

    public static CartesianTransform getTransform(Polygon poly, boolean force) {
        double[] cube = CartesianTransform.getBoundingCube(poly, null);
        return CartesianTransform.getTransform(cube, force);
    }

    public static CartesianTransform getTransform(Circle c) {
        return CartesianTransform.getTransform(c, false);
    }

    public static CartesianTransform getTransform(Circle c, boolean force) {
        double[] xyz = CartesianTransform.toUnitSphere(c.getCenter().getLongitude(), c.getCenter().getLatitude());
        double[] cube = new double[]{xyz[0], xyz[0], xyz[1], xyz[1], xyz[2], xyz[2]};
        return CartesianTransform.getTransform(cube, force);
    }

    public static CartesianTransform getTransform(double[] cube, boolean force) {
        double x1 = cube[0];
        double x2 = cube[1];
        double y1 = cube[2];
        double y2 = cube[3];
        double z1 = cube[4];
        double z2 = cube[5];
        double cx = 0.5 * (x1 + x2);
        double cz = 0.5 * (z1 + z2);
        if (Math.abs(cz) > 0.02 || force) {
            CartesianTransform trans = new CartesianTransform();
            trans.axis = Y;
            double mv1 = Math.sqrt(cx * cx + cz * cz);
            double[] v1 = new double[]{cx / mv1, 0.0, cz / mv1};
            if (cz > 0.0) {
                double[] v2 = new double[]{1.0, 0.0, 0.0};
                double cosa = CartesianTransform.dotProduct(v1, v2);
                trans.angle = Math.acos(cosa) + Math.PI;
            } else {
                double[] v2 = new double[]{-1.0, 0.0, 0.0};
                double cosa = CartesianTransform.dotProduct(v1, v2);
                trans.angle = Math.acos(cosa);
            }
            log.debug((Object)("off equator: " + trans));
            return trans;
        }
        if (y1 <= 0.0 && y2 >= 0.0 && x1 > 0.0) {
            CartesianTransform trans = new CartesianTransform();
            trans.angle = Math.PI;
            trans.axis = Z;
            log.debug((Object)("straddling meridan at equator: " + trans));
            return trans;
        }
        return new CartesianTransform();
    }

    public CartesianTransform getInverseTransform() {
        if (this.isNull()) {
            return this;
        }
        CartesianTransform ret = new CartesianTransform();
        ret.axis = this.axis;
        ret.angle = -1.0 * this.angle;
        return ret;
    }

    public String toString() {
        return "CartesianTransform[" + this.axis + "," + this.angle + "]";
    }

    public boolean isNull() {
        return this.axis == null;
    }

    public static double[] toUnitSphere(double longitude, double latitude) {
        double[] ret = new double[3];
        double theta = Math.toRadians(longitude);
        double phi = Math.toRadians(90.0 - latitude);
        ret[0] = Math.cos(theta) * Math.sin(phi);
        ret[1] = Math.sin(theta) * Math.sin(phi);
        ret[2] = Math.cos(phi);
        return ret;
    }

    public static double[] toLongLat(double x, double y, double z) {
        double[] ret = new double[2];
        ret[0] = x == 0.0 && y == 0.0 || z == 1.0 || z == -1.0 ? 0.0 : Math.toDegrees(Math.atan2(y, x));
        if (ret[0] < 0.0) {
            ret[0] = ret[0] + 360.0;
        }
        if (z > 1.0) {
            z = 1.0;
        } else if (z < -1.0) {
            z = -1.0;
        }
        ret[1] = 90.0 - Math.toDegrees(Math.acos(z));
        return ret;
    }

    public Point transform(Point p) {
        if (this.isNull()) {
            return p;
        }
        double[] p2 = this.transformPoint(p);
        return new Point(p2[0], p2[1]);
    }

    public Polygon transform(Polygon p) {
        if (this.isNull()) {
            return p;
        }
        Polygon ret = new Polygon();
        for (Point v : p.getVertices()) {
            ret.getVertices().add(this.transform(v));
        }
        return ret;
    }

    private double[] transformPoint(Point p) {
        double[] xyz = CartesianTransform.toUnitSphere(p.getLongitude(), p.getLatitude());
        double[] dp = this.rotate(xyz);
        return CartesianTransform.toLongLat(dp[0], dp[1], dp[2]);
    }

    public static double[] getBoundingCube(Polygon poly, double[] cube) {
        if (cube == null) {
            cube = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        }
        for (Point v : poly.getVertices()) {
            double[] xyz = CartesianTransform.toUnitSphere(v.getLongitude(), v.getLatitude());
            cube[0] = Math.min(cube[0], xyz[0]);
            cube[1] = Math.max(cube[1], xyz[0]);
            cube[2] = Math.min(cube[2], xyz[1]);
            cube[3] = Math.max(cube[3], xyz[1]);
            cube[4] = Math.min(cube[4], xyz[2]);
            cube[5] = Math.max(cube[5], xyz[2]);
        }
        if (cube[2] < 0.0 && 0.0 < cube[3] && cube[4] < 0.0 && 0.0 < cube[5]) {
            if (cube[0] > 0.0) {
                cube[1] = 1.01;
            } else if (cube[1] < 0.0) {
                cube[0] = -1.01;
            }
        }
        if (cube[0] < 0.0 && 0.0 < cube[1] && cube[4] < 0.0 && 0.0 < cube[5]) {
            if (cube[2] > 0.0) {
                cube[3] = 1.01;
            } else if (cube[3] < 0.0) {
                cube[2] = -1.01;
            }
        }
        if (cube[0] < 0.0 && 0.0 < cube[1] && cube[2] < 0.0 && 0.0 < cube[3]) {
            if (cube[4] > 0.0) {
                cube[5] = 1.01;
            } else if (cube[5] < 0.0) {
                cube[4] = -1.01;
            }
        }
        return cube;
    }

    private static double dotProduct(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public double[] rotate(double[] p) {
        if (Y.equals(this.axis)) {
            return this.yrotate(p);
        }
        if (Z.equals(this.axis)) {
            return this.zrotate(p);
        }
        throw new IllegalStateException("unknown axis: " + this.axis);
    }

    private double[] yrotate(double[] p) {
        double[] ret = new double[3];
        double cr = Math.cos(this.angle);
        double sr = Math.sin(this.angle);
        ret[0] = cr * p[0] + sr * p[2];
        ret[1] = p[1];
        ret[2] = -1.0 * sr * p[0] + cr * p[2];
        return ret;
    }

    private double[] zrotate(double[] p) {
        double[] ret = new double[3];
        double cr = Math.cos(this.angle);
        double sr = Math.sin(this.angle);
        ret[0] = cr * p[0] + -1.0 * sr * p[1];
        ret[1] = sr * p[0] + cr * p[1];
        ret[2] = p[2];
        return ret;
    }
}

