/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.dali.Circle;
import ca.nrc.cadc.dali.DoubleInterval;
import ca.nrc.cadc.dali.Interval;
import ca.nrc.cadc.dali.PolarizationState;
import ca.nrc.cadc.dali.Polygon;
import ca.nrc.cadc.dali.Shape;
import ca.nrc.cadc.dali.util.CircleFormat;
import ca.nrc.cadc.dali.util.DoubleIntervalFormat;
import ca.nrc.cadc.dali.util.PolygonFormat;
import ca.nrc.cadc.dali.util.ShapeFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonParamValidator {
    private static final Logger log = Logger.getLogger(CommonParamValidator.class);
    public static final String RUNID = "RUNID";
    public static final String RESPONSEFORMAT = "RESPONSEFORMAT";
    public static final String POS = "POS";
    public static final String CIRCLE = "CIRCLE";
    public static final String POLYGON = "POLYGON";
    public static final String BAND = "BAND";
    public static final String TIME = "TIME";
    public static final String POL = "POL";
    public static final String ID = "ID";
    public static final List<String> POL_STATES = Arrays.asList("I", "Q", "U", "V", "RR", "LL", "RL", "LR", "XX", "YY", "XY", "YX", "POLI", "POLA");

    public String getRunID(Map<String, List<String>> params) {
        List<String> values = params.get(RUNID);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public String getResponseFormat(Map<String, List<String>> params) {
        List<String> values = params.get(RESPONSEFORMAT);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    private String scalarToInterval(String s) {
        String[] ss = s.split(" ");
        if (ss.length == 1) {
            return s + " " + s;
        }
        return s;
    }

    public List<Shape> validatePOS(Map<String, List<String>> params) {
        ArrayList<Shape> ret = new ArrayList<Shape>();
        if (params == null) {
            return ret;
        }
        List<String> values = params.get(POS);
        if (values == null) {
            return ret;
        }
        ShapeFormat fmt = new ShapeFormat(true);
        for (String v : values) {
            log.debug((Object)("validatePos: " + v));
            Shape shape = fmt.parse(v);
            ret.add(shape);
        }
        return ret;
    }

    public List<Circle> validateCircle(Map<String, List<String>> params) {
        ArrayList<Circle> ret = new ArrayList<Circle>();
        List<String> values = params.get(CIRCLE);
        if (values == null) {
            return ret;
        }
        CircleFormat cf = new CircleFormat();
        for (String v : values) {
            Circle c = cf.parse(v);
            ret.add(c);
        }
        return ret;
    }

    public List<Polygon> validatePolygon(Map<String, List<String>> params) {
        ArrayList<Polygon> ret = new ArrayList<Polygon>();
        List<String> values = params.get(POLYGON);
        if (values == null) {
            return ret;
        }
        PolygonFormat pf = new PolygonFormat();
        for (String v : values) {
            Polygon p = pf.parse(v);
            ret.add(p);
        }
        return ret;
    }

    public List<Shape> validateAllShapes(Map<String, List<String>> params) {
        List<Shape> ret = this.validatePOS(params);
        List<String> values = params.get(CIRCLE);
        if (values == null) {
            return ret;
        }
        CircleFormat cf = new CircleFormat();
        for (String v : values) {
            Circle shape = cf.parse(v);
            ret.add(shape);
        }
        values = params.get(POLYGON);
        if (values == null) {
            return ret;
        }
        PolygonFormat pf = new PolygonFormat();
        for (String v : values) {
            Polygon shape = pf.parse(v);
            ret.add(shape);
        }
        return ret;
    }

    public List<Interval> validateBAND(Map<String, List<String>> params) {
        ArrayList<Interval> ret = new ArrayList<Interval>();
        if (params == null) {
            return ret;
        }
        List<String> values = params.get(BAND);
        if (values == null) {
            return ret;
        }
        DoubleIntervalFormat fmt = new DoubleIntervalFormat();
        for (String v : values) {
            String vv = this.scalarToInterval(v);
            log.debug((Object)("validateBAND: " + v + " aka " + vv));
            DoubleInterval di = fmt.parse(vv);
            ret.add(di);
        }
        return ret;
    }

    public List<Interval> validateTIME(Map<String, List<String>> params) {
        ArrayList<Interval> ret = new ArrayList<Interval>();
        if (params == null) {
            return ret;
        }
        List<String> values = params.get(TIME);
        if (values == null) {
            return ret;
        }
        DoubleIntervalFormat fmt = new DoubleIntervalFormat();
        for (String v : values) {
            String vv = this.scalarToInterval(v);
            log.debug((Object)("validateBAND: " + v + " aka " + vv));
            DoubleInterval di = fmt.parse(vv);
            ret.add(di);
        }
        return ret;
    }

    public List<PolarizationState> validatePOL(Map<String, List<String>> params) {
        List<String> polParameters;
        ArrayList<PolarizationState> polStates = new ArrayList<PolarizationState>();
        if (params != null && (polParameters = params.get(POL)) != null) {
            for (String polParam : polParameters) {
                polStates.add(PolarizationState.valueOf(polParam.toUpperCase(Locale.ROOT)));
            }
        }
        return polStates;
    }

    public List<String> validateID(Map<String, List<String>> params) {
        return this.validateString(ID, params, null);
    }

    public List<String> validateString(String paramName, Map<String, List<String>> params, Collection<String> allowedValues) {
        ArrayList<String> ret = new ArrayList<String>();
        if (params == null) {
            return ret;
        }
        List<String> values = params.get(paramName);
        if (values == null) {
            return ret;
        }
        for (String s : values) {
            log.debug((Object)("validateString " + paramName + ": " + s));
            if (allowedValues == null) {
                ret.add(s);
                continue;
            }
            if (allowedValues.contains(s)) {
                ret.add(s);
                continue;
            }
            throw new IllegalArgumentException(paramName + " invalid value: " + s);
        }
        return ret;
    }

    public List<Integer> validateInteger(String paramName, Map<String, List<String>> params) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (params == null) {
            return ret;
        }
        List<String> values = params.get(paramName);
        if (values == null) {
            return ret;
        }
        for (String v : values) {
            log.debug((Object)("validateNumeric " + paramName + ": " + v));
            try {
                ret.add(new Integer(v));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(paramName + " invalid value: " + v);
            }
        }
        return ret;
    }

    public List<Interval> validateNumericInterval(String paramName, Map<String, List<String>> params) {
        ArrayList<Interval> ret = new ArrayList<Interval>();
        if (params == null) {
            return ret;
        }
        List<String> values = params.get(paramName);
        if (values == null) {
            return ret;
        }
        DoubleIntervalFormat fmt = new DoubleIntervalFormat();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String v;
            String vv = v = iterator.next();
            log.debug((Object)("validateNumeric " + paramName + ": " + v + " aka " + vv));
            DoubleInterval di = fmt.parse(vv);
            ret.add(di);
        }
        return ret;
    }
}

