/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.dali.DaliUtil;

public class Interval<T extends Number> {
    private T lower;
    private T upper;

    public Interval(T lower, T upper) {
        DaliUtil.assertNotNull("lower", lower);
        DaliUtil.assertNotNull("upper", upper);
        this.validateBounds(lower, upper);
        this.lower = lower;
        this.upper = upper;
    }

    private void validateBounds(T lower, T upper) {
        if (lower instanceof Double) {
            if (((Number)upper).doubleValue() < ((Number)lower).doubleValue()) {
                throw new IllegalArgumentException("invalid interval: " + upper + " < " + lower);
            }
        } else if (lower instanceof Long) {
            if (((Number)upper).longValue() < ((Number)lower).longValue()) {
                throw new IllegalArgumentException("invalid interval: " + upper + " < " + lower);
            }
        } else {
            throw new UnsupportedOperationException("validateBounds numeric type not implemented: " + lower.getClass().getName());
        }
    }

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Interval rhs = (Interval)obj;
        return this.lower.equals(rhs.lower) && this.upper.equals(rhs.upper);
    }

    public Object[] toArray() {
        if (this.lower instanceof Double && this.upper instanceof Double) {
            return new Double[]{(Double)this.lower, (Double)this.upper};
        }
        if (this.lower instanceof Long && this.upper instanceof Long) {
            return new Long[]{(Long)this.lower, (Long)this.upper};
        }
        throw new UnsupportedOperationException("unsupported interval type: " + this.lower.getClass().getName());
    }

    public static Object[] toArray(Interval[] arr) {
        Number[] ret;
        if (arr[0].getLower() instanceof Double) {
            ret = new Double[2 * arr.length];
        } else if (arr[0].getLower() instanceof Long) {
            ret = new Long[2 * arr.length];
        } else {
            throw new UnsupportedOperationException("unsupported interval array type: " + arr[0].getLower().getClass().getName());
        }
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            ret[j] = arr[i].getLower();
            ret[j + 1] = arr[i].getUpper();
            j += 2;
        }
        return ret;
    }

    public static Interval<Double> intersection(Interval<Double> i1, Interval<Double> i2) {
        if (i1.getLower() > i2.getUpper() || i1.getUpper() < i2.getLower()) {
            return null;
        }
        double lb = Math.max(i1.getLower(), i2.getLower());
        double ub = Math.min(i1.getUpper(), i2.getUpper());
        return new Interval<Double>(lb, ub);
    }
}

