/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.ParameterUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class MaxRecValidator {
    private static Logger log = Logger.getLogger(MaxRecValidator.class);
    protected Integer defaultValue;
    protected Integer maxValue;
    protected Job job;
    protected boolean sync;

    public void setDefaultValue(Integer defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setSynchronousMode(boolean sync) {
        this.sync = sync;
    }

    public Integer validate() {
        if (this.job == null) {
            throw new IllegalArgumentException("BUG: job cannot be null");
        }
        String value = ParameterUtil.findParameterValue((String)"MAXREC", (List)this.job.getParameterList());
        if (value == null || value.trim().length() == 0) {
            return this.defaultValue;
        }
        try {
            Integer ret = new Integer(value);
            if (ret < 0) {
                throw new IllegalArgumentException("Invalid MAXREC: " + value);
            }
            if (this.maxValue != null && this.maxValue < ret) {
                return this.maxValue;
            }
            return ret;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid MAXREC: " + value);
        }
    }
}

