/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali;

import ca.nrc.cadc.dali.DaliUtil;
import ca.nrc.cadc.dali.Interval;
import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.Shape;
import org.apache.log4j.Logger;

public class Range
implements Shape {
    private static final Logger log = Logger.getLogger(Range.class);
    private final Interval<Double> longitude;
    private final Interval<Double> latitude;

    public Range(Interval<Double> longitude, Interval<Double> latitude) {
        DaliUtil.assertNotNull("longitude", longitude);
        DaliUtil.assertNotNull("latitude", latitude);
        DaliUtil.assertValidRange("longitude", longitude.getLower(), 0.0, 360.0);
        DaliUtil.assertValidRange("longitude", longitude.getUpper(), 0.0, 360.0);
        DaliUtil.assertValidRange("latitude", latitude.getLower(), -90.0, 90.0);
        DaliUtil.assertValidRange("latitude", latitude.getUpper(), -90.0, 90.0);
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public Interval<Double> getLongitude() {
        return this.longitude;
    }

    public Interval<Double> getLatitude() {
        return this.latitude;
    }

    @Override
    public double getArea() {
        double a = (this.longitude.getUpper() - this.longitude.getLower()) * Math.cos(Math.toRadians(this.latitude.getUpper()));
        double b = (this.longitude.getUpper() - this.longitude.getLower()) * Math.cos(Math.toRadians(this.latitude.getLower()));
        double h = this.latitude.getUpper() - this.latitude.getLower();
        return h * (a + b) / 2.0;
    }

    @Override
    public double getSize() {
        double a = (this.longitude.getUpper() - this.longitude.getLower()) * Math.cos(Math.toRadians(this.latitude.getUpper()));
        double b = (this.longitude.getUpper() - this.longitude.getLower()) * Math.cos(Math.toRadians(this.latitude.getLower()));
        double w = Math.max(a, b);
        double h = this.latitude.getUpper() - this.latitude.getLower();
        return Math.sqrt(w * w + h * h);
    }

    @Override
    public Point getCenter() {
        return new Point(0.5 * (this.longitude.getUpper() + this.longitude.getLower()), 0.5 * (this.latitude.getUpper() + this.latitude.getLower()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Range rhs = (Range)obj;
        return this.longitude.equals(rhs.longitude) && this.latitude.equals(rhs.latitude);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Range.class.getSimpleName()).append("[");
        sb.append(this.longitude).append(",");
        sb.append(this.latitude).append("]");
        return sb.toString();
    }
}

