/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable;

import ca.nrc.cadc.dali.tables.votable.VOTableField;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class FieldElement
extends Element {
    public FieldElement(VOTableField field, Namespace namespace) {
        this("FIELD", field, namespace);
    }

    protected FieldElement(String elementName, VOTableField field, Namespace namespace) {
        super(elementName, namespace);
        this.init(field);
    }

    private void init(VOTableField field) {
        if (field != null) {
            this.setFieldAttribute("name", field.getName());
            this.setFieldAttribute("datatype", field.getDatatype());
            this.setFieldAttribute("arraysize", field.getArraysize());
            this.setFieldAttribute("ID", field.id);
            this.setFieldAttribute("ucd", field.ucd);
            this.setFieldAttribute("unit", field.unit);
            this.setFieldAttribute("utype", field.utype);
            this.setFieldAttribute("xtype", field.xtype);
            this.setFieldAttribute("ref", field.ref);
            this.setFieldAttribute("ID", field.id);
            this.setDescription(field.description, this.namespace);
            this.setValues(field.getValues(), this.namespace);
        }
    }

    protected void setFieldAttribute(String name, Object value) {
        if (value != null) {
            if (value instanceof String) {
                this.setAttribute(name, (String)value);
            } else if (value instanceof Integer) {
                this.setAttribute(name, String.valueOf((Integer)value));
            }
        }
    }

    protected void setDescription(String description, Namespace namespace) {
        if (description != null) {
            Element element = new Element("DESCRIPTION", namespace);
            element.setText(description);
            this.addContent((Content)element);
        }
    }

    protected void setValues(List<String> values, Namespace namespace) {
        if (values != null && !values.isEmpty()) {
            Element element = new Element("VALUES", namespace);
            for (String value : values) {
                Element option = new Element("OPTION", namespace);
                option.setAttribute("value", value);
                element.addContent((Content)option);
            }
            this.addContent((Content)element);
        }
    }
}

