/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable;

import ca.nrc.cadc.dali.tables.BinaryTableData;
import ca.nrc.cadc.dali.tables.ListTableData;
import ca.nrc.cadc.dali.tables.TableData;
import ca.nrc.cadc.dali.tables.votable.VOTableDocument;
import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.VOTableGroup;
import ca.nrc.cadc.dali.tables.votable.VOTableInfo;
import ca.nrc.cadc.dali.tables.votable.VOTableParam;
import ca.nrc.cadc.dali.tables.votable.VOTableResource;
import ca.nrc.cadc.dali.tables.votable.VOTableTable;
import ca.nrc.cadc.dali.tables.votable.VOTableWriter;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.FormatFactory;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class VOTableReader {
    private static final Logger log = Logger.getLogger(VOTableReader.class);
    protected static final String PARSER = "org.apache.xerces.parsers.SAXParser";
    protected static final String GRAMMAR_POOL = "org.apache.xerces.parsers.XMLGrammarCachingConfiguration";
    protected static final String VOTABLE_11_SCHEMA = "VOTable-v1.1.xsd";
    protected static final String VOTABLE_12_SCHEMA = "VOTable-v1.2.xsd";
    protected static final String VOTABLE_13_SCHEMA = "VOTable-v1.3.xsd";
    protected static final String VOTABLE_14_SCHEMA = "VOTable-v1.4.xsd";
    protected static final String[] BINARY_TYPES = new String[]{"BINARY2", "BINARY", "FITS"};
    protected static final String DEFAULT_STREAM_ENCODING = "base64";
    private static final String votable11SchemaUrl = VOTableReader.getSchemaURL("VOTable-v1.1.xsd");
    private static final String votable12SchemaUrl;
    private static final String votable13SchemaUrl;
    private static final String votable14SchemaUrl;
    private FormatFactory formatFactory;
    private SAXBuilder docBuilder;

    static String getSchemaURL(String name) {
        URL url = VOTableReader.class.getClassLoader().getResource(name);
        if (url == null) {
            throw new MissingResourceException("schema not found", VOTableReader.class.getName(), name);
        }
        return url.toString();
    }

    public VOTableReader() {
        this(true);
    }

    public VOTableReader(boolean enableSchemaValidation) {
        HashMap<String, String> schemaMap = null;
        if (enableSchemaValidation) {
            schemaMap = new HashMap<String, String>();
            schemaMap.put("http://www.ivoa.net/xml/VOTable/v1.1", votable11SchemaUrl);
            schemaMap.put("http://www.ivoa.net/xml/VOTable/v1.2", votable12SchemaUrl);
            schemaMap.put("http://www.ivoa.net/xml/VOTable/v1.3", votable14SchemaUrl);
            log.debug((Object)"schema validation enabled");
        } else {
            log.debug((Object)"schema validation disabled");
        }
        this.docBuilder = XmlUtil.createBuilder(schemaMap);
    }

    public void setFormatFactory(FormatFactory formatFactory) {
        this.formatFactory = formatFactory;
    }

    public VOTableDocument read(String xml) throws IOException {
        StringReader reader = new StringReader(xml);
        return this.read(reader);
    }

    public VOTableDocument read(InputStream istream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(istream, "UTF-8"));
        return this.read(reader);
    }

    public VOTableDocument read(Reader reader) throws IOException {
        if (this.formatFactory == null) {
            this.formatFactory = new FormatFactory();
        }
        return this.readImpl(reader);
    }

    protected VOTableDocument readImpl(Reader reader) throws IOException {
        Document document;
        try {
            document = this.docBuilder.build(reader);
        }
        catch (JDOMException e) {
            reader.close();
            throw new IOException("Unable to parse " + e.getMessage());
        }
        VOTableDocument votable = new VOTableDocument();
        Element root = document.getRootElement();
        Namespace namespace = root.getNamespace();
        log.debug((Object)("Namespace: " + namespace));
        List documentInfos = root.getChildren("INFO", namespace);
        votable.getInfos().addAll(this.getInfos(documentInfos, namespace));
        List resources = root.getChildren("RESOURCE", namespace);
        for (Element resource : resources) {
            Element description;
            Attribute idAttr;
            Attribute nameAttr;
            Attribute typeAttr = resource.getAttribute("type");
            VOTableResource votResource = new VOTableResource(typeAttr.getValue());
            votable.getResources().add(votResource);
            Attribute utypeAttr = resource.getAttribute("utype");
            if (utypeAttr != null) {
                votResource.utype = utypeAttr.getValue();
            }
            if ((nameAttr = resource.getAttribute("name")) != null) {
                votResource.setName(nameAttr.getValue());
            }
            if ((idAttr = resource.getAttribute("ID")) != null) {
                votResource.id = idAttr.getValue();
            }
            if ((description = resource.getChild("DESCRIPTION", namespace)) != null) {
                votResource.description = description.getText();
            }
            List resourceInfos = resource.getChildren("INFO", namespace);
            log.debug((Object)("found resource.info: " + resourceInfos.size()));
            votResource.getInfos().addAll(this.getInfos(resourceInfos, namespace));
            List params = resource.getChildren("PARAM", namespace);
            log.debug((Object)("found resource.param: " + params.size()));
            votResource.getParams().addAll(this.getParams(params, namespace));
            List groups = resource.getChildren("GROUP", namespace);
            log.debug((Object)("found resource.group: " + groups.size()));
            votResource.getGroups().addAll(this.getGroups(groups, namespace));
            Element table = resource.getChild("TABLE", namespace);
            if (table == null) continue;
            VOTableTable vot = new VOTableTable();
            votResource.setTable(vot);
            List tableInfos = table.getChildren("INFO", namespace);
            log.debug((Object)("found resource.table.info: " + tableInfos.size()));
            vot.getInfos().addAll(this.getInfos(tableInfos, namespace));
            List tparams = table.getChildren("PARAM", namespace);
            log.debug((Object)("found resource.table.param: " + tparams.size()));
            vot.getParams().addAll(this.getParams(tparams, namespace));
            List tfields = table.getChildren("FIELD", namespace);
            log.debug((Object)("found resource.table.field: " + tfields.size()));
            vot.getFields().addAll(this.getFields(tfields, namespace));
            Element data = table.getChild("DATA", namespace);
            if (data == null) continue;
            Element tableData = data.getChild("TABLEDATA", namespace);
            if (tableData != null) {
                vot.setTableData(this.getTableData(tableData, namespace, vot.getFields(), reader));
                continue;
            }
            Element binaryData = this.getBinaryData(data, namespace);
            if (binaryData == null) {
                reader.close();
                throw new UnsupportedOperationException("Unknown DATA");
            }
            Element streamData = binaryData.getChild("STREAM", namespace);
            if (streamData == null) {
                vot.setTableData(new ListTableData(reader));
                continue;
            }
            String encoding = streamData.getAttributeValue("encoding", DEFAULT_STREAM_ENCODING);
            if (binaryData.getName().equals(VOTableWriter.SerializationType.BINARY.name()) || binaryData.getName().equals(VOTableWriter.SerializationType.BINARY2.name())) {
                vot.setTableData(new BinaryTableData(new ByteArrayInputStream(streamData.getText().getBytes(StandardCharsets.UTF_8)), vot.getFields(), encoding, this.formatFactory, binaryData.getName().equals(VOTableWriter.SerializationType.BINARY2.name())));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type: " + binaryData.getName());
        }
        return votable;
    }

    Element getBinaryData(Element dataElement, Namespace namespace) {
        for (String nextTagName : BINARY_TYPES) {
            Element nextPotentialBinaryElement = dataElement.getChild(nextTagName, namespace);
            if (nextPotentialBinaryElement == null) continue;
            return nextPotentialBinaryElement;
        }
        return null;
    }

    protected List<VOTableInfo> getInfos(List<Element> elements, Namespace namespace) {
        ArrayList<VOTableInfo> infos = new ArrayList<VOTableInfo>();
        for (Element element : elements) {
            String id;
            String name = element.getAttributeValue("name");
            String value = element.getAttributeValue("value");
            if (!StringUtil.hasText((String)name) || !StringUtil.hasText((String)value)) continue;
            VOTableInfo i = new VOTableInfo(name, value);
            String s = element.getText();
            log.debug((Object)("INFO content: " + s));
            if (StringUtil.hasText((String)s)) {
                i.content = s;
            }
            if (StringUtil.hasText((String)(id = element.getAttributeValue("ID")))) {
                i.id = id;
            }
            infos.add(i);
        }
        return infos;
    }

    protected List<VOTableGroup> getGroups(List<Element> elements, Namespace namespace) {
        ArrayList<VOTableGroup> ret = new ArrayList<VOTableGroup>();
        for (Element element : elements) {
            String name = element.getAttributeValue("name");
            VOTableGroup vg = new VOTableGroup(name);
            List params = element.getChildren("PARAM", namespace);
            log.debug((Object)("found group.param: " + params.size()));
            vg.getParams().addAll(this.getParams(params, namespace));
            List groups = element.getChildren("GROUP", namespace);
            log.debug((Object)("found group.group: " + groups.size()));
            vg.getGroups().addAll(this.getGroups(groups, namespace));
            ret.add(vg);
        }
        return ret;
    }

    protected List<VOTableParam> getParams(List<Element> elements, Namespace namespace) {
        ArrayList<VOTableParam> params = new ArrayList<VOTableParam>();
        for (Element element : elements) {
            String name = element.getAttributeValue("name");
            String datatype = element.getAttributeValue("datatype");
            String arraysize = element.getAttributeValue("arraysize");
            String value = element.getAttributeValue("value");
            VOTableParam tableParam = new VOTableParam(name, datatype, arraysize, value);
            this.updateTableField(tableParam, element, namespace);
            params.add(tableParam);
        }
        return params;
    }

    protected List<VOTableField> getFields(List<Element> elements, Namespace namespace) {
        ArrayList<VOTableField> fields = new ArrayList<VOTableField>();
        for (Element element : elements) {
            String name = element.getAttributeValue("name");
            String datatype = element.getAttributeValue("datatype");
            String arraysize = element.getAttributeValue("arraysize");
            VOTableField tableField = new VOTableField(name, datatype, arraysize);
            this.updateTableField(tableField, element, namespace);
            fields.add(tableField);
        }
        return fields;
    }

    protected void updateTableField(VOTableField tableField, Element element, Namespace namespace) {
        Element values;
        tableField.id = element.getAttributeValue("ID");
        tableField.ucd = element.getAttributeValue("ucd");
        tableField.unit = element.getAttributeValue("unit");
        tableField.utype = element.getAttributeValue("utype");
        tableField.xtype = element.getAttributeValue("xtype");
        tableField.ref = element.getAttributeValue("ref");
        Element description = element.getChild("DESCRIPTION", namespace);
        if (description != null) {
            tableField.description = description.getText();
        }
        if ((values = element.getChild("VALUES", namespace)) != null) {
            List options = values.getChildren("OPTION", namespace);
            if (!options.isEmpty()) {
                for (Element option : options) {
                    tableField.getValues().add(option.getAttributeValue("value"));
                }
            }
            if (values.hasAttributes()) {
                String nullValue = values.getAttributeValue("null");
                tableField.nullValue = nullValue == null ? null : nullValue.trim();
            }
        }
    }

    TableData getTableData(Element element, Namespace namespace, List<VOTableField> fields, Reader reader) {
        ListTableData tableData = new ListTableData(reader);
        if (element != null) {
            List trs = element.getChildren("TR", namespace);
            for (Element tr : trs) {
                ArrayList row = new ArrayList();
                List tds = tr.getChildren("TD", namespace);
                for (int i = 0; i < tds.size(); ++i) {
                    Object nullObj;
                    Element td = (Element)tds.get(i);
                    VOTableField field = fields.get(i);
                    Format format = this.formatFactory.getFormat(field);
                    String text = td.getTextTrim();
                    if (text != null && text.length() == 0) {
                        text = null;
                    }
                    Object parsedData = format.parse(text);
                    if (field.nullValue != null && !field.nullValue.isEmpty() && Objects.equals(parsedData, nullObj = this.formatFactory.getFormat(field).parse(field.nullValue))) {
                        parsedData = null;
                    }
                    row.add(parsedData);
                }
                tableData.getArrayList().add(row);
            }
        }
        return tableData;
    }

    static {
        log.debug((Object)("votable11SchemaUrl: " + votable11SchemaUrl));
        votable12SchemaUrl = VOTableReader.getSchemaURL(VOTABLE_12_SCHEMA);
        log.debug((Object)("votable12SchemaUrl: " + votable12SchemaUrl));
        votable13SchemaUrl = VOTableReader.getSchemaURL(VOTABLE_13_SCHEMA);
        log.debug((Object)("votable13SchemaUrl: " + votable13SchemaUrl));
        votable14SchemaUrl = VOTableReader.getSchemaURL(VOTABLE_14_SCHEMA);
        log.debug((Object)("votable14SchemaUrl: " + votable14SchemaUrl));
    }
}

