/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable;

import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.binary.BinaryElementWriter;
import ca.nrc.cadc.dali.tables.votable.tabledata.TableDataElementWriter;
import ca.nrc.cadc.dali.util.FormatFactory;
import ca.nrc.cadc.xml.MaxIterations;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.util.NamespaceStack;

public class XMLOutputProcessor
extends AbstractXMLOutputProcessor {
    private static final Logger log = Logger.getLogger(XMLOutputProcessor.class);
    private final Iterator<List<Object>> rowIter;
    private final List<VOTableField> fields;
    private final FormatFactory formatFactory;
    private final MaxIterations maxIterations;
    private final Element trailer;

    public XMLOutputProcessor(Iterator<List<Object>> rowIter, List<VOTableField> fields, MaxIterations maxIterations, Element trailer, FormatFactory formatFactory) {
        this.rowIter = rowIter;
        this.fields = fields;
        this.maxIterations = maxIterations;
        this.trailer = trailer;
        this.formatFactory = formatFactory;
    }

    protected void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
        if (element.getName().equals("BINARY2")) {
            log.debug((Object)"Writing BINARY2 element");
            BinaryElementWriter binaryWriter = new BinaryElementWriter(this.rowIter, this.fields, this.maxIterations, this.trailer);
            binaryWriter.write(out);
        } else if (element.getName().equals("TABLEDATA")) {
            log.debug((Object)"Writing TABLEDATA element");
            TableDataElementWriter tableWriter = new TableDataElementWriter(this.rowIter, this.fields, this.maxIterations, this.trailer, this.formatFactory);
            tableWriter.write(out);
        } else {
            super.printElement(out, fstack, nstack, element);
        }
    }
}

