/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable.binary;

import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.VOTableUtil;
import ca.nrc.cadc.dali.tables.votable.binary.FieldProcessor;
import ca.nrc.cadc.dali.tables.votable.binary.FieldProcessorFactory;
import ca.nrc.cadc.dali.util.FormatFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BinaryRowReader {
    private final List<VOTableField> fields;
    private final FieldProcessorFactory decoderFactory = new FieldProcessorFactory();
    private final FormatFactory formatFactory;
    private final boolean isBinary2;

    public BinaryRowReader(List<VOTableField> fields, FormatFactory formatFactory, boolean isBinary2) {
        this.fields = fields;
        this.formatFactory = formatFactory == null ? new FormatFactory() : formatFactory;
        this.isBinary2 = isBinary2;
    }

    public List<Object> readRow(DataInputStream in) throws IOException {
        int numMaskBytes;
        int read;
        int numFields = this.fields.size();
        byte[] nullMask = null;
        if (this.isBinary2 && (read = in.read(nullMask = new byte[numMaskBytes = (numFields + 7) / 8])) < numMaskBytes) {
            return null;
        }
        ArrayList<Object> row = new ArrayList<Object>(numFields);
        for (int i = 0; i < numFields; ++i) {
            if (this.isBinary2) {
                boolean isNull;
                boolean bl = isNull = (nullMask[i / 8] & 1 << 7 - i % 8) != 0;
                if (isNull) {
                    row.add(null);
                    continue;
                }
            }
            VOTableField field = this.fields.get(i);
            int length = BinaryRowReader.computeLength(in, field);
            FieldProcessor fieldProcessor = this.decoderFactory.getFieldProcessor(field.getDatatype().toLowerCase());
            Object rawData = fieldProcessor.deSerialize(in, field, length);
            String stringValue = fieldProcessor.toStringValue(length, rawData);
            row.add(this.parseAndResolveNull(field, stringValue));
        }
        return row;
    }

    private static int computeLength(DataInputStream in, VOTableField field) throws IOException {
        int[] shape = VOTableUtil.parseArraySize(field.getArraysize());
        int length = 1;
        if (shape != null) {
            int variableDim = 1;
            if (shape[shape.length - 1] == -1) {
                variableDim = in.readInt();
            }
            for (int dim : shape) {
                if (dim == -1) {
                    dim = variableDim;
                }
                length *= dim;
            }
        }
        return length;
    }

    private Object parseAndResolveNull(VOTableField field, String stringValue) {
        Object parsedData = this.formatFactory.getFormat(field).parse(stringValue);
        if (field.nullValue != null && !field.nullValue.isEmpty()) {
            Object nullValue = this.formatFactory.getFormat(field).parse(field.nullValue);
            if (Objects.equals(parsedData, nullValue)) {
                parsedData = null;
            }
        } else if (parsedData instanceof Float && Float.isNaN(((Float)parsedData).floatValue())) {
            parsedData = null;
        } else if (parsedData instanceof Double && Double.isNaN((Double)parsedData)) {
            parsedData = null;
        }
        return parsedData;
    }
}

