/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.tables.votable.binary;

import ca.nrc.cadc.dali.Circle;
import ca.nrc.cadc.dali.Interval;
import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.Polygon;
import ca.nrc.cadc.dali.tables.votable.VOTableField;
import ca.nrc.cadc.dali.tables.votable.VOTableUtil;
import ca.nrc.cadc.dali.tables.votable.binary.FieldProcessor;
import ca.nrc.cadc.dali.util.UTCTimestampFormat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class FieldProcessorFactory {
    private final Map<String, FieldProcessor> decoders = new HashMap<String, FieldProcessor>();

    public FieldProcessorFactory() {
        this.decoders.put("int", new IntFieldProcessor());
        this.decoders.put("long", new LongFieldProcessor());
        this.decoders.put("short", new ShortFieldProcessor());
        this.decoders.put("float", new FloatFieldProcessor());
        this.decoders.put("double", new DoubleFieldProcessor());
        this.decoders.put("char", new StringFieldProcessor());
        this.decoders.put("boolean", new BooleanFieldProcessor());
        this.decoders.put("unsignedbyte", new ByteFieldProcessor());
    }

    public FieldProcessor getFieldProcessor(String datatype) {
        FieldProcessor decoder = this.decoders.get(datatype);
        if (decoder == null) {
            throw new IllegalArgumentException("Unsupported datatype: " + datatype);
        }
        return decoder;
    }

    private static int computeVariableDim(VOTableField field, int arrayDataSize) throws IOException {
        int[] shape = VOTableUtil.parseArraySize(field.getArraysize());
        int variableDim = arrayDataSize;
        int product = 1;
        if (shape != null && shape[shape.length - 1] == -1) {
            for (int i = 0; i < shape.length - 1; ++i) {
                product *= shape[i];
            }
            if (arrayDataSize % product != 0) {
                throw new IOException("arrayDataSize not divisible by fixed dimensions: " + Arrays.toString(shape));
            }
            variableDim = arrayDataSize / product;
        }
        return variableDim;
    }

    public static class ByteFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            if (length == 1) {
                return in.readByte();
            }
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return bytes;
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            if (field.getArraysize() == null) {
                out.writeByte(((Number)value).byteValue());
                return;
            }
            boolean isVariable = field.getArraysize().contains("*");
            byte[] array = (byte[])value;
            if (isVariable) {
                int variableDim = FieldProcessorFactory.computeVariableDim(field, array.length);
                out.writeInt(variableDim);
            }
            for (byte data : array) {
                out.writeByte(data);
            }
        }

        @Override
        public String toStringValue(int len, Object data) {
            if (len == 1) {
                return data.toString();
            }
            byte[] arr = (byte[])data;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(Byte.toUnsignedInt(arr[i]));
            }
            return sb.toString().trim();
        }
    }

    public static class BooleanFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            if (length == 1) {
                return in.readBoolean();
            }
            throw new UnsupportedOperationException("Boolean Arrays are not supported");
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            if (field.getArraysize() == null) {
                out.writeBoolean((Boolean)value);
                return;
            }
            throw new UnsupportedOperationException("Boolean Arrays are not supported");
        }

        @Override
        public String toStringValue(int len, Object data) {
            return data.toString();
        }
    }

    public static class LongFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            if (length == 1) {
                return in.readLong();
            }
            long[] arr = new long[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = in.readLong();
            }
            return arr;
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            int i;
            long[] array;
            if (field.getArraysize() == null) {
                out.writeLong(((Number)value).longValue());
                return;
            }
            boolean isVariable = field.getArraysize().contains("*");
            if (value instanceof long[]) {
                array = (long[])value;
            } else if (value instanceof Interval) {
                Interval interval = (Interval)value;
                Object[] array1 = interval.toArray();
                array = new long[array1.length];
                for (i = 0; i < array1.length; ++i) {
                    array[i] = ((Number)array1[i]).longValue();
                }
            } else if (value instanceof Interval[]) {
                Interval[] intervals = (Interval[])value;
                Object[] intervalsArray = Interval.toArray(intervals);
                array = new long[intervalsArray.length];
                for (i = 0; i < intervalsArray.length; ++i) {
                    array[i] = ((Number)intervalsArray[i]).longValue();
                }
            } else {
                throw new UnsupportedOperationException("Unsupported array data type: " + value.getClass().getName());
            }
            if (isVariable) {
                int variableDim = FieldProcessorFactory.computeVariableDim(field, array.length);
                out.writeInt(variableDim);
            }
            for (long data : array) {
                out.writeLong(data);
            }
        }

        @Override
        public String toStringValue(int len, Object data) {
            if (len == 1) {
                return data.toString();
            }
            long[] arr = (long[])data;
            return Arrays.stream(arr).mapToObj(Long::toString).collect(Collectors.joining(" "));
        }
    }

    public static class DoubleFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            if (length == 1) {
                return in.readDouble();
            }
            double[] arr = new double[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = in.readDouble();
            }
            return arr;
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            int i;
            Object p;
            double[] array;
            if (field.getArraysize() == null) {
                out.writeDouble(((Number)value).doubleValue());
                return;
            }
            boolean isVariable = field.getArraysize().contains("*");
            if (value instanceof double[]) {
                array = (double[])value;
            } else if (value instanceof double[][]) {
                double[][] mda = (double[][])value;
                int totalLength = 0;
                for (double[] inner : mda) {
                    totalLength += inner.length;
                }
                array = new double[totalLength];
                int idx = 0;
                double[][] dArray = mda;
                int n = dArray.length;
                for (int j = 0; j < n; ++j) {
                    double[] inner;
                    for (double val : inner = dArray[j]) {
                        array[idx++] = val;
                    }
                }
            } else if (value instanceof Point) {
                p = (Point)value;
                array = ((Point)p).toArray();
            } else if (value instanceof Circle) {
                Circle c = (Circle)value;
                array = c.toArray();
            } else if (value instanceof Polygon) {
                p = (Polygon)value;
                array = ((Polygon)p).toArray();
            } else if (value instanceof Interval) {
                Interval interval = (Interval)value;
                Object[] intervalArray = interval.toArray();
                array = new double[intervalArray.length];
                for (i = 0; i < intervalArray.length; ++i) {
                    array[i] = ((Number)intervalArray[i]).doubleValue();
                }
            } else if (value instanceof Interval[]) {
                Interval[] intervals = (Interval[])value;
                Object[] intervalsArray = Interval.toArray(intervals);
                array = new double[intervalsArray.length];
                for (i = 0; i < intervalsArray.length; ++i) {
                    array[i] = ((Number)intervalsArray[i]).doubleValue();
                }
            } else {
                throw new UnsupportedOperationException("Unsupported array data type: " + value.getClass().getName());
            }
            if (isVariable) {
                int variableDim = FieldProcessorFactory.computeVariableDim(field, array.length);
                out.writeInt(variableDim);
            }
            for (double data : array) {
                out.writeDouble(data);
            }
        }

        @Override
        public String toStringValue(int len, Object data) {
            if (len == 1) {
                return data.toString();
            }
            double[] arr = (double[])data;
            return Arrays.stream(arr).mapToObj(Double::toString).collect(Collectors.joining(" "));
        }
    }

    public static class FloatFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            if (length == 1) {
                return Float.valueOf(in.readFloat());
            }
            float[] arr = new float[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = in.readFloat();
            }
            return arr;
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            if (field.getArraysize() == null) {
                out.writeFloat(((Number)value).floatValue());
                return;
            }
            boolean isVariable = field.getArraysize().contains("*");
            float[] array = (float[])value;
            if (isVariable) {
                int variableDim = FieldProcessorFactory.computeVariableDim(field, array.length);
                out.writeInt(variableDim);
            }
            for (float data : array) {
                out.writeFloat(data);
            }
        }

        @Override
        public String toStringValue(int len, Object data) {
            if (len == 1) {
                return data.toString();
            }
            float[] arr = (float[])data;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(arr[i]);
            }
            return sb.toString().trim();
        }
    }

    public static class ShortFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            if (length == 1) {
                return in.readShort();
            }
            short[] arr = new short[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = in.readShort();
            }
            return arr;
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            if (field.getArraysize() == null) {
                out.writeShort(((Number)value).shortValue());
                return;
            }
            boolean isVariable = field.getArraysize().contains("*");
            short[] array = (short[])value;
            if (isVariable) {
                int variableDim = FieldProcessorFactory.computeVariableDim(field, array.length);
                out.writeInt(variableDim);
            }
            for (short data : array) {
                out.writeShort(data);
            }
        }

        @Override
        public String toStringValue(int len, Object data) {
            if (len == 1) {
                return data.toString();
            }
            short[] arr = (short[])data;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(arr[i]);
            }
            return sb.toString().trim();
        }
    }

    public static class IntFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            if (length == 1) {
                return in.readInt();
            }
            int[] arr = new int[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = in.readInt();
            }
            return arr;
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            if (field.getArraysize() == null) {
                out.writeInt(((Number)value).intValue());
                return;
            }
            boolean isVariable = field.getArraysize().contains("*");
            int[] array = (int[])value;
            if (isVariable) {
                int variableDim = FieldProcessorFactory.computeVariableDim(field, array.length);
                out.writeInt(variableDim);
            }
            for (int data : array) {
                out.writeInt(data);
            }
        }

        @Override
        public String toStringValue(int len, Object data) {
            if (len == 1) {
                return data.toString();
            }
            int[] arr = (int[])data;
            return Arrays.stream(arr).mapToObj(Integer::toString).collect(Collectors.joining(" "));
        }
    }

    public static class StringFieldProcessor
    implements FieldProcessor {
        @Override
        public Object deSerialize(DataInputStream in, VOTableField field, int length) throws IOException {
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new String(bytes, StandardCharsets.UTF_8).trim();
        }

        @Override
        public void serialize(DataOutputStream out, VOTableField field, Object value) throws IOException {
            UTCTimestampFormat timestampFormat;
            if (value instanceof Date) {
                timestampFormat = new UTCTimestampFormat();
                value = timestampFormat.format((Date)value);
            } else if (value instanceof Instant) {
                timestampFormat = new UTCTimestampFormat();
                value = timestampFormat.format(Date.from((Instant)value));
            }
            byte[] bytes = value.toString().getBytes(StandardCharsets.UTF_8);
            if (field.getArraysize().contains("*")) {
                int variableDim = FieldProcessorFactory.computeVariableDim(field, bytes.length);
                out.writeInt(variableDim);
            }
            out.write(bytes);
        }

        @Override
        public String toStringValue(int len, Object data) {
            return data.toString();
        }
    }
}

