/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.util.Format;
import java.util.Iterator;

public class DoubleArray2DFormat
implements Format<double[][]> {
    private int[] arrayshape;

    public DoubleArray2DFormat(int[] arrayshape) {
        this.arrayshape = arrayshape;
    }

    @Override
    public String format(double[][] object) {
        if (object == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < object.length; ++i) {
            for (int j = 0; j < object[i].length; ++j) {
                sb.append(Double.toString(object[i][j]));
                sb.append(" ");
            }
        }
        return sb.toString().trim();
    }

    @Override
    public String format(Iterator<Double> iter) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            sb.append(" ");
        }
        sb.trimToSize();
        return sb.toString();
    }

    @Override
    public double[][] parse(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String[] tokens = s.split(" +");
        int n1 = this.arrayshape[0];
        int n2 = tokens.length / this.arrayshape[0];
        double[][] array = new double[n1][n2];
        int i = 0;
        int j = 0;
        for (int t = 0; t < tokens.length; ++t) {
            array[i][j] = Double.parseDouble(tokens[t]);
            if (++j != n2) continue;
            j = 0;
            ++i;
        }
        return array;
    }
}

