/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.DoubleInterval;
import ca.nrc.cadc.dali.Interval;
import ca.nrc.cadc.dali.util.DoubleArrayFormat;
import ca.nrc.cadc.dali.util.Format;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class DoubleIntervalArrayFormat
implements Format<Interval<Double>[]> {
    private static final Logger log = Logger.getLogger(DoubleIntervalArrayFormat.class);
    private DoubleArrayFormat fmt = new DoubleArrayFormat();

    @Override
    public Interval<Double>[] parse(String s) {
        if (s == null) {
            return null;
        }
        DoubleArrayFormat daf = new DoubleArrayFormat();
        double[] vv = daf.parse(s);
        int len = vv.length / 2;
        DoubleInterval[] ret = new DoubleInterval[len];
        try {
            for (int i = 0; i < vv.length; i += 2) {
                ret[i / 2] = new DoubleInterval(vv[i], vv[i + 1]);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("invalid array length for array of interval: " + vv.length);
        }
        return ret;
    }

    @Override
    public String format(final Interval<Double>[] t) {
        if (t == null) {
            return "";
        }
        return this.fmt.format(new Iterator<Double>(){
            private int num = 0;
            private int numDI = 0;

            @Override
            public boolean hasNext() {
                return this.numDI < t.length;
            }

            @Override
            public Double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Interval di = t[this.numDI];
                if (this.num == 0) {
                    ++this.num;
                    return (Double)di.getLower();
                }
                ++this.numDI;
                this.num = 0;
                return (Double)di.getUpper();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }
}

