/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.DoubleInterval;
import ca.nrc.cadc.dali.Interval;
import ca.nrc.cadc.dali.util.DoubleArrayFormat;
import ca.nrc.cadc.dali.util.Format;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class DoubleIntervalFormat
implements Format<Interval<Double>> {
    private static final Logger log = Logger.getLogger(DoubleIntervalFormat.class);
    private DoubleArrayFormat fmt = new DoubleArrayFormat();

    @Override
    public DoubleInterval parse(String s) {
        if (s == null) {
            return null;
        }
        DoubleArrayFormat daf = new DoubleArrayFormat();
        double[] vv = daf.parse(s);
        if (vv.length != 2) {
            throw new IllegalArgumentException();
        }
        return new DoubleInterval(vv[0], vv[1]);
    }

    @Override
    public String format(final Interval<Double> t) {
        if (t == null) {
            return "";
        }
        return this.fmt.format(new Iterator<Double>(){
            private int num = 0;

            @Override
            public boolean hasNext() {
                return this.num < 2;
            }

            @Override
            public Double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.num;
                if (this.num == 1) {
                    return (Double)t.getLower();
                }
                return (Double)t.getUpper();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }
}

