/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.MultiPolygon;
import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.Polygon;
import ca.nrc.cadc.dali.util.DoubleArrayFormat;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.PolygonFormat;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MultiPolygonFormat
implements Format<MultiPolygon> {
    private static final Logger log = Logger.getLogger(MultiPolygonFormat.class);
    private final PolygonFormat pf = new PolygonFormat();
    private final DoubleArrayFormat fmt = new DoubleArrayFormat();
    private static final String MP_SEPARATOR = " NaN NaN ";

    @Override
    public MultiPolygon parse(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        double[] dd = this.fmt.parse(s);
        return this.parseDoubleNaN(dd, s);
    }

    public MultiPolygon build(double[] dd) {
        return this.parseDoubleNaN(dd, null);
    }

    public static double[] toArray(MultiPolygon mp) {
        int num = 0;
        Iterator<Polygon> i = mp.getPolygons().iterator();
        while (i.hasNext()) {
            Polygon poly = i.next();
            num += 2 * poly.getVertices().size();
            if (!i.hasNext()) continue;
            num += 2;
        }
        double[] ret = new double[num];
        int n = 0;
        i = mp.getPolygons().iterator();
        while (i.hasNext()) {
            Polygon poly = i.next();
            double[] da = poly.toArray();
            System.arraycopy(da, 0, ret, n, da.length);
            n += da.length;
            if (!i.hasNext()) continue;
            ret[n++] = Double.NaN;
            ret[n++] = Double.NaN;
        }
        return ret;
    }

    MultiPolygon parseDoubleNaN(double[] dd, String s) {
        MultiPolygon ret = new MultiPolygon();
        Polygon poly = new Polygon();
        try {
            for (int i = 0; i < dd.length; i += 2) {
                if (Double.isNaN(dd[i])) {
                    if (Double.isNaN(dd[i + 1])) {
                        if (poly.getVertices().size() < 3) {
                            throw new IllegalArgumentException("invalid multipolygon (not enough points before NaN NaN separator): " + s);
                        }
                        ret.getPolygons().add(poly);
                        poly = new Polygon();
                        continue;
                    }
                    throw new IllegalArgumentException("invalid polygon (NaN coordinate value): " + s);
                }
                if (Double.isNaN(dd[i + 1])) {
                    throw new IllegalArgumentException("invalid polygon (NaN coordinate value): " + s);
                }
                Point v = new Point(dd[i], dd[i + 1]);
                poly.getVertices().add(v);
            }
            if (poly.getVertices().size() < 3) {
                throw new IllegalArgumentException("invalid multipolygon (not enough points in last polygon): " + s);
            }
            ret.getPolygons().add(poly);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("invalid polygon (odd number of coordinate values): " + s);
        }
        return ret;
    }

    MultiPolygon parseSingleNaN(String s) {
        String[] comps = s.toLowerCase().split("nan");
        log.warn((Object)("MultiPolygonFormat.parse: " + comps.length));
        MultiPolygon ret = new MultiPolygon();
        for (String c : comps) {
            if ((c = c.trim()).isEmpty()) {
                throw new IllegalArgumentException("invalid polygon (interpretting 'NaN NaN' as a NaN coordinate value): " + s);
            }
            log.warn((Object)("MultiPolygonFormat.parse: '" + c + "'"));
            Polygon p = this.pf.parse(c);
            ret.getPolygons().add(p);
        }
        return ret;
    }

    @Override
    public String format(MultiPolygon mp) {
        if (mp == null || mp.getPolygons().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Polygon> i = mp.getPolygons().iterator();
        while (i.hasNext()) {
            sb.append(this.pf.format(i.next()));
            if (!i.hasNext()) continue;
            sb.append(MP_SEPARATOR);
        }
        return sb.toString();
    }
}

