/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.MultiShape;
import ca.nrc.cadc.dali.Shape;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.ShapeFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MultiShapeFormat
implements Format<MultiShape> {
    private static final Logger log = Logger.getLogger(MultiShapeFormat.class);
    private final ShapeFormat fmt = new ShapeFormat();

    @Override
    public MultiShape parse(String s) {
        if (s == null) {
            return null;
        }
        List<String> sep = this.separate(s);
        MultiShape ret = new MultiShape();
        for (String str : sep) {
            Shape shape = this.fmt.parse(str);
            ret.getShapes().add(shape);
        }
        return ret;
    }

    @Override
    public String format(MultiShape t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Shape> i = t.getShapes().iterator();
        while (i.hasNext()) {
            Shape s = i.next();
            sb.append(this.fmt.format(s));
            if (!i.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    List<String> separate(String s) {
        String[] tokens;
        ArrayList<String> ret = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(^c)|( c)|(^p)|( p)");
        for (String string : tokens = pattern.split(s)) {
            void var8_8;
            String string2 = string.trim();
            if (string2.startsWith("ircle")) {
                String string3 = "c" + string2;
            } else if (string2.startsWith("olygon")) {
                String string4 = "p" + string2;
            }
            if (var8_8.isEmpty()) continue;
            ret.add((String)var8_8);
        }
        return ret;
    }
}

