/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.PolarizationState;
import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.dali.util.PolarizationStateFormat;
import ca.nrc.cadc.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PolarizationStateListFormat
implements Format<List<PolarizationState>> {
    private static final Logger log = Logger.getLogger(PolarizationStateListFormat.class);
    public static final String DELIMITER = "|";
    private PolarizationStateFormat pf = new PolarizationStateFormat();

    @Override
    public List<PolarizationState> parse(String str) {
        String[] ss;
        ArrayList<PolarizationState> ret = new ArrayList<PolarizationState>();
        if (!StringUtil.hasText((String)str)) {
            return ret;
        }
        if (!(str = str.trim()).startsWith(DELIMITER) || !str.endsWith(DELIMITER)) {
            throw new IllegalArgumentException("missing initial or final delimiter(s) (|): " + str);
        }
        str = str.substring(1, str.length() - 1);
        for (String s : ss = str.split("\\|")) {
            ret.add(PolarizationState.valueOf(s));
        }
        return ret;
    }

    @Override
    public String format(List<PolarizationState> ps) {
        if (ps == null || ps.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(DELIMITER);
        for (PolarizationState p : ps) {
            sb.append(this.pf.format(p)).append(DELIMITER);
        }
        return sb.toString();
    }
}

