/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.DoubleInterval;
import ca.nrc.cadc.dali.Interval;
import ca.nrc.cadc.dali.Range;
import ca.nrc.cadc.dali.util.DoubleArrayFormat;
import ca.nrc.cadc.dali.util.DoubleIntervalArrayFormat;
import ca.nrc.cadc.dali.util.Format;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class RangeFormat
implements Format<Range> {
    private static final Logger log = Logger.getLogger(RangeFormat.class);
    private final DoubleIntervalArrayFormat diaf = new DoubleIntervalArrayFormat();
    private final DoubleArrayFormat fmt = new DoubleArrayFormat();
    private final boolean sia2;

    public RangeFormat() {
        this.sia2 = false;
    }

    public RangeFormat(boolean supportSIA2) {
        this.sia2 = supportSIA2;
    }

    @Override
    public Range parse(String s) {
        Interval<Double>[] dis = this.diaf.parse(s);
        if (dis.length != 2) {
            throw new IllegalArgumentException("invalid range: found " + dis.length + " intervals");
        }
        if (this.sia2) {
            double long1 = dis[0].getLower();
            if (dis[0].getLower().isInfinite()) {
                long1 = 0.0;
            }
            double long2 = dis[0].getUpper();
            if (dis[0].getUpper().isInfinite()) {
                long2 = 360.0;
            }
            double lat1 = dis[1].getLower();
            if (dis[1].getLower().isInfinite()) {
                lat1 = -90.0;
            }
            double lat2 = dis[1].getUpper();
            if (dis[1].getUpper().isInfinite()) {
                lat2 = 90.0;
            }
            return new Range(new DoubleInterval(long1, long2), new DoubleInterval(lat1, lat2));
        }
        return new Range(dis[0], dis[1]);
    }

    @Override
    public String format(final Range t) {
        if (t == null) {
            return "";
        }
        return this.fmt.format(new Iterator<Double>(){
            private int num = 0;

            @Override
            public boolean hasNext() {
                return this.num < 4;
            }

            @Override
            public Double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.num;
                switch (this.num) {
                    case 1: {
                        double d = t.getLongitude().getLower();
                        return d;
                    }
                    case 2: {
                        double d = t.getLongitude().getUpper();
                        return d;
                    }
                    case 3: {
                        double d = t.getLatitude().getLower();
                        return d;
                    }
                    case 4: {
                        double d = t.getLatitude().getUpper();
                        return d;
                    }
                }
                throw new RuntimeException("BUG: range coordinate iteration reached " + this.num);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }
}

