/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.util.Format;
import ca.nrc.cadc.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StringListFormat
implements Format<List<String>> {
    private static final Logger log = Logger.getLogger(StringListFormat.class);
    public static final String DELIMITER = "|";

    @Override
    public List<String> parse(String str) {
        String[] ss;
        ArrayList<String> ret = new ArrayList<String>();
        if (!StringUtil.hasText((String)str)) {
            return ret;
        }
        if (!(str = str.trim()).startsWith(DELIMITER) || !str.endsWith(DELIMITER)) {
            throw new IllegalArgumentException("missing initial or final delimiter(s) (|): " + str);
        }
        str = str.substring(1, str.length() - 1);
        for (String s : ss = str.split("\\|")) {
            ret.add(s);
        }
        return ret;
    }

    @Override
    public String format(List<String> strs) {
        if (strs == null || strs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(DELIMITER);
        for (String s : strs) {
            sb.append(s).append(DELIMITER);
        }
        return sb.toString();
    }
}

